/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

public class StatUtil {
    private static final double P_LOW = 0.02425;
    private static final double P_HIGH = 0.97575;
    private static final double[] ICDF_A = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
    private static final double[] ICDF_B = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
    private static final double[] ICDF_C = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
    private static final double[] ICDF_D = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};
    private static final double[] ERF_A = new double[]{3.1611237438705655, 113.86415415105016, 377.485237685302, 3209.3775891384694, 0.18577770618460315};
    private static final double[] ERF_B = new double[]{23.601290952344122, 244.02463793444417, 1282.6165260773723, 2844.236833439171};
    private static final double[] ERF_C = new double[]{0.5641884969886701, 8.883149794388377, 66.11919063714163, 298.6351381974001, 881.952221241769, 1712.0476126340707, 2051.0783778260716, 1230.3393547979972, 2.1531153547440383E-8};
    private static final double[] ERF_D = new double[]{15.744926110709835, 117.6939508913125, 537.1811018620099, 1621.3895745666903, 3290.7992357334597, 4362.619090143247, 3439.3676741437216, 1230.3393548037495};
    private static final double[] ERF_P = new double[]{0.30532663496123236, 0.36034489994980445, 0.12578172611122926, 0.016083785148742275, 6.587491615298378E-4, 0.016315387137302097};
    private static final double[] ERF_Q = new double[]{2.568520192289822, 1.8729528499234604, 0.5279051029514285, 0.06051834131244132, 0.0023352049762686918};
    private static final double PI_SQRT = Math.sqrt(Math.PI);
    private static final double THRESHOLD = 0.46875;
    private static final double X_MIN = Double.MIN_VALUE;
    private static final double X_INF = Double.MAX_VALUE;
    private static final double X_NEG = -9.38241396824444;
    private static final double X_SMALL = (double)1.110223E-16f;
    private static final double X_BIG = 9.194;
    private static final double X_HUGE = 1.0 / (2.0 * Math.sqrt(1.110223E-16f));
    private static final double X_MAX = Math.min(Double.MAX_VALUE, 1.0 / (Math.sqrt(Math.PI) * Double.MIN_VALUE));

    private StatUtil() {
    }

    public static double getInvCDF(double d, boolean highPrecision) {
        double z = 0.0;
        if (d == 0.0) {
            z = Double.NEGATIVE_INFINITY;
        } else if (d == 1.0) {
            z = Double.POSITIVE_INFINITY;
        } else if (Double.isNaN(d) || d < 0.0 || d > 1.0) {
            z = Double.NaN;
        } else if (d < 0.02425) {
            double q = Math.sqrt(-2.0 * Math.log(d));
            z = (((((ICDF_C[0] * q + ICDF_C[1]) * q + ICDF_C[2]) * q + ICDF_C[3]) * q + ICDF_C[4]) * q + ICDF_C[5]) / ((((ICDF_D[0] * q + ICDF_D[1]) * q + ICDF_D[2]) * q + ICDF_D[3]) * q + 1.0);
        } else if (0.97575 < d) {
            double q = Math.sqrt(-2.0 * Math.log(1.0 - d));
            z = -(((((ICDF_C[0] * q + ICDF_C[1]) * q + ICDF_C[2]) * q + ICDF_C[3]) * q + ICDF_C[4]) * q + ICDF_C[5]) / ((((ICDF_D[0] * q + ICDF_D[1]) * q + ICDF_D[2]) * q + ICDF_D[3]) * q + 1.0);
        } else {
            double q = d - 0.5;
            double r = q * q;
            z = (((((ICDF_A[0] * r + ICDF_A[1]) * r + ICDF_A[2]) * r + ICDF_A[3]) * r + ICDF_A[4]) * r + ICDF_A[5]) * q / (((((ICDF_B[0] * r + ICDF_B[1]) * r + ICDF_B[2]) * r + ICDF_B[3]) * r + ICDF_B[4]) * r + 1.0);
        }
        if (highPrecision) {
            z = StatUtil.refine(z, d);
        }
        return z;
    }

    private static double calerf(double x, int jint) {
        double y_SQ;
        double result = 0.0;
        double y = Math.abs(x);
        if (y <= 0.46875) {
            double y_SQ2 = 0.0;
            if (y > (double)1.110223E-16f) {
                y_SQ2 = y * y;
            }
            double x_NUM = ERF_A[4] * y_SQ2;
            double x_DEN = y_SQ2;
            for (int i = 0; i < 3; ++i) {
                x_NUM = (x_NUM + ERF_A[i]) * y_SQ2;
                x_DEN = (x_DEN + ERF_B[i]) * y_SQ2;
            }
            result = x * (x_NUM + ERF_A[3]) / (x_DEN + ERF_B[3]);
            if (jint != 0) {
                result = 1.0 - result;
            }
            if (jint == 2) {
                result = Math.exp(y_SQ2) * result;
            }
            return result;
        }
        if (y <= 4.0) {
            double x_NUM = ERF_C[8] * y;
            double x_DEN = y;
            for (int i = 0; i < 7; ++i) {
                x_NUM = (x_NUM + ERF_C[i]) * y;
                x_DEN = (x_DEN + ERF_D[i]) * y;
            }
            result = (x_NUM + ERF_C[7]) / (x_DEN + ERF_D[7]);
            if (jint != 2) {
                y_SQ = (double)Math.round(y * 16.0) / 16.0;
                double del = (y - y_SQ) * (y + y_SQ);
                result = Math.exp(-y_SQ * y_SQ) * Math.exp(-del) * result;
            }
        } else {
            result = 0.0;
            if (!(y >= 9.194) || jint == 2 && !(y >= X_MAX)) {
                if (y >= 9.194 && y >= X_HUGE) {
                    result = PI_SQRT / y;
                } else {
                    y_SQ = 1.0 / (y * y);
                    double x_NUM = ERF_P[5] * y_SQ;
                    double x_DEN = y_SQ;
                    for (int i = 0; i < 4; ++i) {
                        x_NUM = (x_NUM + ERF_P[i]) * y_SQ;
                        x_DEN = (x_DEN + ERF_Q[i]) * y_SQ;
                    }
                    result = y_SQ * (x_NUM + ERF_P[4]) / (x_DEN + ERF_Q[4]);
                    result = (PI_SQRT - result) / y;
                    if (jint != 2) {
                        y_SQ = (double)Math.round(y * 16.0) / 16.0;
                        double del = (y - y_SQ) * (y + y_SQ);
                        result = Math.exp(-y_SQ * y_SQ) * Math.exp(-del) * result;
                    }
                }
            }
        }
        if (jint == 0) {
            result = 0.5 - result + 0.5;
            if (x < 0.0) {
                result = -result;
            }
        } else if (jint == 1) {
            if (x < 0.0) {
                result = 2.0 - result;
            }
        } else if (x < 0.0) {
            if (x < -9.38241396824444) {
                result = Double.MAX_VALUE;
            } else {
                y_SQ = (double)Math.round(x * 16.0) / 16.0;
                double del = (x - y_SQ) * (x + y_SQ);
                y = Math.exp(y_SQ * y_SQ) * Math.exp(del);
                result = y + y - result;
            }
        }
        return result;
    }

    public static double erf(double d) {
        return StatUtil.calerf(d, 0);
    }

    public static double erfc(double d) {
        return StatUtil.calerf(d, 1);
    }

    public static double erfcx(double d) {
        return StatUtil.calerf(d, 2);
    }

    public static double refine(double x, double d) {
        double y;
        if (d > 0.0 && d < 1.0) {
            double e = 0.5 * StatUtil.erfc(-x / Math.sqrt(2.0)) - d;
            double u = e * Math.sqrt(Math.PI * 2) * Math.exp(x * x / 2.0);
            y = x - u / (1.0 + x * u / 2.0);
        } else {
            y = x;
        }
        return y;
    }
}

