/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.services;

import org.homelinux.elabor.scriptorium.services.AbstractTextSearcher;
import org.homelinux.elabor.scriptorium.services.TextSearcher;

class WholeWordDecorator
extends AbstractTextSearcher {
    private static String[] delimiters = new String[]{" ", "\n", "\\", "|", "!", "\"", "\u00a3", "$", "%", "&", "/", "(", ")", "=", "'", "?", "^", "[", "]", "{", "}", "@", "\u00e7", "\u00b0", "#", "\u00a7", ",", ";", ".", ":", "-", "_", "<", ">", "+", "\u2020"};

    public WholeWordDecorator(TextSearcher searcher) {
        this.searcher = searcher;
    }

    private static boolean isValidDelimiter(String character) {
        boolean is_delimiter = false;
        String[] stringArray = delimiters;
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            if (character.equals(delimiter)) {
                is_delimiter = true;
                break;
            }
            ++n2;
        }
        return is_delimiter;
    }

    private static boolean isWholeWord(String text, String match, int position) {
        boolean right;
        boolean left;
        try {
            String before = text.substring(position - 1, position);
            left = WholeWordDecorator.isValidDelimiter(before);
        }
        catch (StringIndexOutOfBoundsException exp) {
            left = true;
        }
        try {
            int end_offset = position + match.length();
            String after = text.substring(end_offset, end_offset + 1);
            right = WholeWordDecorator.isValidDelimiter(after);
        }
        catch (StringIndexOutOfBoundsException exp) {
            right = true;
        }
        return left && right;
    }

    @Override
    public int search(String text, String match, int offset) {
        int position = this.searcher.search(text, match, offset);
        int result = position == -1 ? position : (WholeWordDecorator.isWholeWord(text, match, position) ? position : this.search(text, match, position));
        return result;
    }
}

