/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftProjectionManager;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.tools.MathUtils;

class VerticalManager
implements DraftProjectionManager {
    VerticalManager() {
    }

    @Override
    public void execute(DraftVector vector, ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        double x = vector.getX();
        double y = vector.getY();
        double dx = vector.getDx();
        double dy = vector.getDy();
        if (dx == 0.0) {
            throw new InvalidValueException("vertical projection is impossible");
        }
        double k = dy / dx;
        double xp = point.getX();
        double yt = MathUtils.round(y + k * (xp - x), 3);
        point.setSnap(xp, yt);
    }

    public String toString() {
        return "VERTICAL".toLowerCase();
    }
}

