/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import java.util.List;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.w3c.dom.Element;

public final class SnapAction
extends AbstractAction<SnapAction> {
    private static final String TARGET = "target";

    public SnapAction() {
    }

    public SnapAction(Element element) {
        super(element);
    }

    @Override
    public String getElementName() {
        return "snap";
    }

    @Override
    protected SnapAction make(Element element) {
        return new SnapAction(element);
    }

    public void setTarget(ComputeAction action) {
        this.setIntAttribute(TARGET, action.getId());
    }

    public int getTarget() {
        return this.getIntAttribute(TARGET);
    }

    @Override
    public String toString() {
        return "Snap " + this.getStringAttribute(TARGET);
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void execute(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        List<PointReference> pointReferences = this.getPointReferences();
        List<ScriptoriumPoint> points = ShapeAdapter.getReferredPoints(pointReferences, drawingPoints);
        ComputeAction target = this.getTargetAction(drawingActions);
        if (target != null) {
            target.project(points, drawingPoints, drawingActions);
        }
    }

    private ComputeAction getTargetAction(Iterable<ComputeAction> actions) {
        int targetRef = this.getTarget();
        ComputeAction target = null;
        for (ComputeAction action : actions) {
            if (action.getId() != targetRef) continue;
            target = action;
            break;
        }
        return target;
    }

    @Override
    protected void project(DraftVector vector, ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
    }

    @Override
    protected Shape computeShape(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        return null;
    }

    @Override
    public boolean isConicBy(ScriptoriumPoint point) {
        return false;
    }

    @Override
    protected DraftVector getTangent(ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints) {
        return null;
    }

    @Override
    public ComputeAction getTargetConic(ScriptoriumPoint point, Iterable<ComputeAction> actions) {
        AbstractAction<?> targetAction;
        int id = point.getId();
        List<PointReference> points = this.getPointReferences();
        ComputeAction target = null;
        for (PointReference current : points) {
            if (id != current.getId()) continue;
            target = this.getTargetAction(actions);
            break;
        }
        ComputeAction targetConic = null;
        if (target != null && (targetAction = target.getAction()).isConic()) {
            targetConic = target;
        }
        return targetConic;
    }

    @Override
    public boolean isConic() {
        return false;
    }
}

