/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.scriptorium.ndraft.actions.HyperbolaDefinition;
import org.homelinux.elabor.scriptorium.ndraft.actions.HyperbolaEquation;

class DefinizioneConiugata
implements HyperbolaDefinition {
    private final HyperbolaDefinition hyperbolaDefinition;
    private final double minSemiAxis;
    private final double maxSemiAxis;

    public DefinizioneConiugata(HyperbolaDefinition hyperbolaDefinition, double minSemiAxis, double maxSemiAxis) {
        this.hyperbolaDefinition = hyperbolaDefinition;
        this.minSemiAxis = minSemiAxis;
        this.maxSemiAxis = maxSemiAxis;
    }

    @Override
    public int getNumBranches() {
        return this.hyperbolaDefinition.getNumBranches();
    }

    @Override
    public boolean hasFixedPoints() {
        return this.hyperbolaDefinition.hasFixedPoints();
    }

    @Override
    public Point2D getCenter2D(Iterable<ScriptoriumPoint> drawingPoints) {
        Point2D center = this.hyperbolaDefinition.getCenter2D(drawingPoints);
        if (center == null) {
            Point2D vertex1 = this.hyperbolaDefinition.getVertex12D(drawingPoints);
            Point2D vertex2 = this.hyperbolaDefinition.getVertex22D(drawingPoints);
            center = GeometricHelper.middlePoint(vertex1, vertex2);
        }
        return center;
    }

    @Override
    public Point2D getVertex12D(Iterable<ScriptoriumPoint> drawingPoints) {
        Point2D vertex1 = this.hyperbolaDefinition.getVertex12D(drawingPoints);
        Point2D center = this.getCenter2D(drawingPoints);
        DraftVector axis = GeometricHelper.orthogonal(center, vertex1);
        return GeometricHelper.shift(axis, this.maxSemiAxis);
    }

    @Override
    public Point2D getVertex22D(Iterable<ScriptoriumPoint> drawingPoints) {
        Point2D center = this.getCenter2D(drawingPoints);
        Point2D vertex1 = this.getVertex12D(drawingPoints);
        return GeometricHelper.symmetric(vertex1, center);
    }

    @Override
    public Point2D getPassingBy2D(Iterable<ScriptoriumPoint> drawingPoints) {
        Point2D center = this.getCenter2D(drawingPoints);
        Point2D vertex1 = this.getVertex12D(drawingPoints);
        return HyperbolaEquation.getHyperbolaPoint(center, vertex1, this.minSemiAxis, this.minSemiAxis, 1);
    }

    @Override
    public Point2D getStart2D(Iterable<ScriptoriumPoint> drawingPoints) {
        return this.hyperbolaDefinition.getStart2D(drawingPoints);
    }

    @Override
    public Point2D getEnd2D(Iterable<ScriptoriumPoint> drawingPoints) {
        return this.hyperbolaDefinition.getEnd2D(drawingPoints);
    }
}

