/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.ActionsHelper;
import org.homelinux.elabor.scriptorium.ndraft.ChoosePointsArea;
import org.homelinux.elabor.scriptorium.ndraft.DirectionArea;
import org.homelinux.elabor.scriptorium.ndraft.LineDirection;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingFrame;
import org.homelinux.elabor.scriptorium.ndraft.ProjectionSetter;
import org.homelinux.elabor.scriptorium.ndraft.ProjectionsArea;
import org.homelinux.elabor.scriptorium.ndraft.SingleButtonHandler;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftProjection;
import org.homelinux.elabor.ui.UITools;

public class DirectionLineDialog
extends JDialog
implements ActionListener,
ProjectionSetter {
    private static final long serialVersionUID = 1L;
    private final NDraftDrawingFrame frame;
    private final List<ScriptoriumPoint> points;
    private final Map<ScriptoriumPoint, ComputeAction> pointsAction;
    private SingleButtonHandler handler;
    private final DirectionArea directionArea;
    private DraftProjection projection;

    public DirectionLineDialog(NDraftDrawingFrame frame, List<ScriptoriumPoint> points, Iterable<ComputeAction> actions, Iterable<ScriptoriumPoint> drawingPoints) {
        this.setModal(false);
        this.frame = frame;
        this.pointsAction = ActionsHelper.buildPointsAction(points);
        this.setSize(1000, 700);
        this.setTitle("choose fixed point and direction line properties");
        this.setDefaultCloseOperation(2);
        this.points = points;
        this.handler = new SingleButtonHandler();
        ChoosePointsArea pointsArea = new ChoosePointsArea(this.handler, "point", this.points, this.pointsAction, actions, drawingPoints, true, false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        UITools.addComponent(contentPane, pointsArea, 0, 0, 1, 1, 100, 100, 1, 2);
        this.directionArea = new DirectionArea("line direction", drawingPoints);
        UITools.addComponent(contentPane, this.directionArea, 0, 1, 1, 1, 100, 100, 1, 2);
        ProjectionsArea projectionsArea = new ProjectionsArea(this);
        UITools.addComponent(contentPane, projectionsArea, 0, 2, 1, 1, 100, 1, 2, 2);
        JButton button = new JButton("ok");
        button.addActionListener(this);
        UITools.addComponent(contentPane, button, 0, 3, 1, 1, 100, 10, 0, 2);
        this.projection = null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ScriptoriumPoint fixedPoint = this.handler.getSelectedPoint();
        if (fixedPoint == null || this.projection == null) {
            JOptionPane.showMessageDialog(null, "you should select the fixed point and the projection type");
        } else {
            try {
                LineDirection lineDirection = this.directionArea.getLineDirection();
                this.dispose();
                this.frame.addDirectionLine(this.pointsAction, fixedPoint, lineDirection, this.projection);
            }
            catch (InvalidValueException exc) {
                String message = "the value '" + exc.getValue() + "' is invalid as " + exc.getMessage();
                JOptionPane.showMessageDialog(null, message);
            }
        }
    }

    @Override
    public void setProjection(DraftProjection projection) {
        this.projection = projection;
    }
}

