/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.tongues;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.tongues.TongueFrame;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class TonguesPanel
extends OldScriptoriumListArea<Tongue> {
    private static final long serialVersionUID = 1L;
    private TongueFrame tongueFrame;

    public TonguesPanel() {
        super(false, true, true);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.TONGUES);
        this.setCellRenderer(renderer);
        LineBorder border = new LineBorder(Color.black);
        this.setBorder(border);
        this.tongueFrame = new TongueFrame();
    }

    @Override
    public void setup(ScriptoriumDirector director, Tongue tongue) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<Tongue> tongues = content.getTongues();
        super.setup(director, tongues, tongue);
    }

    private void openTongueFrame(int index) {
        GenericSelectionModel<Tongue> model = this.getModel();
        this.tongueFrame.setup(model, index);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void remAction(int index, Tongue tongue) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        this.getDirector().downgradeComponent(tongue);
    }

    @Override
    public void editAction(int index, Tongue tongue) {
        this.openTongueFrame(index);
    }

    @Override
    public boolean closing() {
        if (this.tongueFrame != null) {
            this.tongueFrame.dispose();
        }
        return super.closing();
    }
}

