/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.places;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.places.PlaceFrame;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class PlacesPanel
extends OldScriptoriumListArea<Place> {
    private static final long serialVersionUID = 1L;
    private PlaceFrame placeFrame;

    public PlacesPanel() {
        super(false, true, true);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.PLACES);
        this.setCellRenderer(renderer);
        LineBorder border = new LineBorder(Color.black);
        this.setBorder(border);
        this.placeFrame = new PlaceFrame();
    }

    @Override
    public void setup(ScriptoriumDirector director, Place place) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<Place> places = content.getPlaces();
        super.setup(director, places, place);
    }

    private void openPlaceFrame(int index) {
        GenericSelectionModel<Place> model = this.getModel();
        this.placeFrame.setup(model, index);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void remAction(int index, Place place) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        this.getDirector().downgradeComponent(place);
    }

    @Override
    public void editAction(int index, Place place) {
        this.openPlaceFrame(index);
    }

    @Override
    public boolean closing() {
        if (this.placeFrame != null) {
            this.placeFrame.dispose();
        }
        return super.closing();
    }
}

