/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.mathconcepts;

import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.OntologyRefererPanel;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class MathConceptPanel
extends OntologyRefererPanel<MathConcept> {
    private static final long serialVersionUID = 1L;
    private JLabel mathConceptLabel;
    private final Highlighter highlighter;

    public MathConceptPanel() {
        JScrollPane scrollableList = this.createScrollPane(2);
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        this.mathConceptLabel = UITools.setupLabel("", fontSize);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.mathConceptLabel, 0, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, scrollableList, 0, 1, 1, 1, 100, 100, 1, 2);
        EditionManager editionManager = EditionManager.getInstance();
        Ontology ontology = editionManager.getMathConceptsOntology();
        this.setOntology(ontology);
        this.highlighter = new Highlighter(OntologyInitialiser.MATH_CONCEPTS);
    }

    public void setup(GenericSelectionModel<MathConcept> mathConcepts, int index) {
        MathConcept mathConcept = (MathConcept)mathConcepts.get(index);
        this.setReferer(mathConcept);
        this.highlighter.visit(mathConcept);
        String text = this.highlighter.getText();
        this.mathConceptLabel.setText(text);
        this.selectIndices();
    }
}

