/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.transformations;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.itools.DefaultPanel;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Transform;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class DrawingMagnificationPanel
extends ScriptoriumPanel<Transform> {
    private static final long serialVersionUID = 1L;
    private String magnificationString;
    private String xMagnificationString;
    private String yMagnificationString;
    private JTextField magnificationField;
    private JTextField xMagnificationField;
    private JTextField yMagnificationField;
    private DrawingDirector director;

    public DrawingMagnificationPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        JLabel magnification_label = new JLabel(this.magnificationString, 4);
        this.magnificationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel xMagnification_label = new JLabel(this.xMagnificationString, 4);
        this.xMagnificationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel yMagnification_label = new JLabel(this.yMagnificationString, 4);
        this.yMagnificationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, magnification_label, 0, 0, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.magnificationField, 1, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, xMagnification_label, 0, 1, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.xMagnificationField, 1, 1, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, yMagnification_label, 0, 2, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.yMagnificationField, 1, 2, 1, 1, 100, 1, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.magnificationString = catalog.translate("magnification");
        this.xMagnificationString = catalog.translate("xMagnification");
        this.yMagnificationString = catalog.translate("yMagnification");
    }

    public void setup(DrawingDirector drawingDirector) {
        this.director = drawingDirector;
        this.magnificationField.setText("1");
        this.xMagnificationField.setText("0");
        this.yMagnificationField.setText("0");
    }

    @Override
    public boolean okAction() {
        boolean ok;
        String magText = this.magnificationField.getText();
        DefaultPanel.CheckDoubleField checkMag = this.checkDoubleField(magText, this.magnificationString);
        String xMagText = this.xMagnificationField.getText();
        DefaultPanel.CheckDoubleField checkXMag = this.checkDoubleField(xMagText, this.xMagnificationString);
        String yMagText = this.yMagnificationField.getText();
        DefaultPanel.CheckDoubleField checkYMag = this.checkDoubleField(yMagText, this.yMagnificationString);
        boolean bl = ok = checkMag.ok && checkXMag.ok && checkYMag.ok;
        if (ok) {
            this.director.executeDrawingMagnification(checkMag.value, checkXMag.value, checkYMag.value);
        }
        return ok;
    }
}

