/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.groups;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Glyph;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.GlyphGroup;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.GlyphVisitor;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapeGUI;
import org.homelinux.elabor.tools.MessageCatalog;

class GlyphRenderer
extends DefaultListCellRenderer
implements GlyphVisitor {
    private static final long serialVersionUID = 1L;
    private MessageCatalog catalog;

    public GlyphRenderer() {
        this.initLocale();
    }

    private void initLocale() {
        this.catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        this.catalog.loadCatalog(this.getClass().getName(), locale);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        Glyph glyph = (Glyph)value;
        glyph.accept(this);
        return this;
    }

    @Override
    public void visit(GlyphGroup group) {
    }

    @Override
    public void visit(ScriptoriumPoint point) {
        String text = "[" + this.catalog.translate("point") + "] ";
        text = String.valueOf(text) + point.toString();
        this.setText(text);
    }

    @Override
    public void visit(ScriptoriumShape shape) {
        String text = "[" + this.catalog.translate("shape") + "] ";
        String label = shape.getShape().getLabel();
        if (label.isEmpty()) {
            ShapeGUI gui = new ShapeGUI(shape.getShape());
            label = gui.getGUIName();
        }
        text = String.valueOf(text) + shape.getId() + "-" + label;
        this.setText(text);
    }
}

