/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import javax.swing.undo.UndoableEditSupport;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.gui.drawings.DefaultDrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.SelectPointAction;
import org.homelinux.elabor.scriptorium.gui.drawings.SelectShapeAction;
import org.homelinux.elabor.scriptorium.gui.drawings.UnselectAllAction;

class SelectManager {
    private ScriptoriumPoint selectedPoint;
    private ScriptoriumShape selectedShape;
    private DefaultDrawingDirector director;
    private UndoableEditSupport undoSupport;

    public SelectManager(DefaultDrawingDirector director, UndoableEditSupport undoSupport) {
        this.director = director;
        this.undoSupport = undoSupport;
        this.selectedPoint = null;
        this.selectedShape = null;
    }

    public void setSelectedPoint(ScriptoriumPoint selectedPoint) {
        this.selectedPoint = selectedPoint;
    }

    public void setSelectedShape(ScriptoriumShape selectedShape) {
        this.selectedShape = selectedShape;
    }

    public void recordShapeSelection(ScriptoriumShape shape) {
        if (this.selectedShape != shape) {
            SelectShapeAction effect = new SelectShapeAction(this.director, this.selectedPoint, this.selectedShape, shape);
            this.undoSupport.postEdit(effect);
            this.selectedPoint = null;
            this.selectedShape = shape;
        }
    }

    public void recordPointSelection(ScriptoriumPoint point) {
        if (this.selectedPoint != point) {
            SelectPointAction effect = new SelectPointAction(this.director, this.selectedPoint, this.selectedShape, point);
            this.undoSupport.postEdit(effect);
            this.selectedPoint = point;
            this.selectedShape = null;
        }
    }

    public void unselectAll() {
        UnselectAllAction effect = new UnselectAllAction(this.director, this.selectedPoint, this.selectedShape);
        this.undoSupport.postEdit(effect);
        this.selectedPoint = null;
        this.selectedShape = null;
    }
}

