/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.itools.CartesianGraphics;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.BackgroundImage;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Transform;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.LabelAnchorType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.Style;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSet;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSetReference;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingArea;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointsManager;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStyle;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.ui.GenericSelectionModel;

public abstract class AbstractDrawingDirector
implements DrawingDirector {
    private static final long serialVersionUID = 1L;
    protected Drawing drawing;
    private DrawingArea drawingArea;
    private List<ScriptoriumStyle> styles;
    protected PointsManager pointsManager = new PointsManager();

    @Override
    public void refreshPointsArea() {
        this.pointsManager.repaint();
    }

    @Override
    public ScriptoriumShape createShape(AbstractShape<?> innerShape) {
        ScriptoriumShape shape = new ScriptoriumShape(this.drawing);
        shape.setId(this.drawing.newShapeId());
        shape.createChild(innerShape);
        this.drawing.addShape(shape);
        innerShape.setVisible(true);
        return shape;
    }

    @Override
    public Iterable<ComputeAction> getComputeActions() {
        return this.drawing.getComputeActions();
    }

    public void setDrawing(Drawing drawing) {
        this.drawing = drawing;
    }

    @Override
    public Drawing getDrawing() {
        return this.drawing;
    }

    @Override
    public DrawingArea getDrawingArea() {
        return this.drawingArea;
    }

    public void setDrawingArea(DrawingArea drawingArea) {
        this.drawingArea = drawingArea;
    }

    @Override
    public int getOriginX() {
        return this.drawing.getOriginX();
    }

    @Override
    public int getOriginY() {
        return this.drawing.getOriginY();
    }

    @Override
    public int getWidth() {
        return this.drawing.getWidth();
    }

    @Override
    public int getHeight() {
        return this.drawing.getHeight();
    }

    @Override
    public void setExportableArea(int ulX, int ulY, int width, int height) {
        this.setOrigin(ulX, ulY);
        this.setDimensions(width, height);
        this.drawingArea.changeLayout();
    }

    public void setExportableAreaByBackground() {
        Image image = this.drawingArea.getBackgroundImage();
        if (image != null) {
            Point2D origin = this.getBackgroundOrigin(image);
            Rectangle rectangle = this.getBackgroundRectangle(image);
            int leftX = (int)origin.getX();
            int ulY = (int)origin.getY();
            int width = rectangle.width;
            int height = rectangle.height;
            this.setExportableArea(leftX, ulY, width, height);
        }
    }

    @Override
    public Rectangle2D getTransformedRectangle(CartesianGraphics cartesianGraphics) {
        int leftX = this.getOriginX();
        int ulY = this.getOriginY();
        int width = this.getWidth();
        int height = this.getHeight();
        Point2D point = cartesianGraphics.getTransformPoint2D(leftX, ulY);
        int xMin = (int)point.getX();
        int yMin = (int)point.getY();
        Rectangle2D.Double transformedRectangle = new Rectangle2D.Double(xMin, yMin + height, width, height);
        return transformedRectangle;
    }

    @Override
    public void executeDrawingTranslation(double xTrans, double yTrans) {
        AffineTransform at = new AffineTransform();
        at.translate(xTrans, yTrans);
        this.executeDrawingTransform(at, false);
    }

    @Override
    public void executeDrawingMagnification(double mag, double centerX, double centerY) {
        Iterable<ScriptoriumPoint> points = this.getPoints();
        for (ScriptoriumPoint point : points) {
            double oldX = point.getX();
            double newX = AbstractDrawingDirector.getMagnificationCoordinate(mag, centerX, oldX);
            point.setX(newX);
            double oldY = point.getY();
            double newY = AbstractDrawingDirector.getMagnificationCoordinate(mag, centerY, oldY);
            point.setY(newY);
        }
        this.drawingArea.changeLayout();
        this.drawingArea.repaint();
    }

    private static double getMagnificationCoordinate(double mag, double center, double oldAbsolute) {
        double oldRelative = oldAbsolute - center;
        double newRelative = oldRelative * mag;
        double newAbsolute = newRelative + center;
        return newAbsolute;
    }

    @Override
    public void executeDrawingInversion(boolean horizontalAxe, double axeCoordinate) {
        this.executePointsInversion(horizontalAxe, axeCoordinate);
        this.executeAnchorsInversion(horizontalAxe, axeCoordinate);
        this.drawingArea.changeLayout();
        this.drawingArea.repaint();
    }

    private void executePointsInversion(boolean horizontalAxe, double axeCoordinate) {
        Iterable<ScriptoriumPoint> points = this.getPoints();
        for (ScriptoriumPoint point : points) {
            if (horizontalAxe) {
                double oldY = point.getY();
                double newY = 2.0 * axeCoordinate - oldY;
                point.setY(newY);
                continue;
            }
            double oldX = point.getX();
            double newX = 2.0 * axeCoordinate - oldX;
            point.setX(newX);
        }
    }

    private void executeAnchorsInversion(boolean horizontalAxe, double axeCoordinate) {
        GenericSelectionModel<ScriptoriumShape> shapes = this.getShapesModel();
        for (ScriptoriumShape shape : shapes) {
            Point2D.Double newAbsolutePosition;
            AbstractShape<?> abstractShape = shape.getShape();
            Point2D oldAbsolutePosition = this.getAbsoluteLabelPosition(abstractShape);
            double oldAbsX = oldAbsolutePosition.getX();
            double oldAbsY = oldAbsolutePosition.getY();
            if (horizontalAxe) {
                double newAbsY = 2.0 * axeCoordinate - oldAbsY;
                newAbsolutePosition = new Point2D.Double(oldAbsX, newAbsY);
            } else {
                double newAbsX = 2.0 * axeCoordinate - oldAbsX;
                newAbsolutePosition = new Point2D.Double(newAbsX, oldAbsY);
            }
            Point2D newRelativePosition = this.getRelativeLabelPosition(abstractShape, newAbsolutePosition);
            abstractShape.setLabelPosition(newRelativePosition);
        }
    }

    private Point2D getAbsoluteLabelPosition(AbstractShape<?> abstractShape) {
        Point2D anchor = this.getAnchorPosition(abstractShape);
        double anchorX = anchor.getX();
        double anchorY = anchor.getY();
        Point2D relLabelPosition = abstractShape.getLabelPosition();
        double relX = relLabelPosition.getX();
        double relY = relLabelPosition.getY();
        double absX = anchorX + relX;
        double absY = anchorY + relY;
        Point2D.Double absoluteLabelPosition = new Point2D.Double(absX, absY);
        return absoluteLabelPosition;
    }

    private Point2D getRelativeLabelPosition(AbstractShape<?> abstractShape, Point2D absoluteLabelPosition) {
        Point2D anchor = this.getAnchorPosition(abstractShape);
        double anchorX = anchor.getX();
        double anchorY = anchor.getY();
        double absX = absoluteLabelPosition.getX();
        double absY = absoluteLabelPosition.getY();
        double relX = absX - anchorX;
        double relY = absY - anchorY;
        Point2D.Double relativeLabelPosition = new Point2D.Double(relX, relY);
        return relativeLabelPosition;
    }

    @Override
    public void executeDrawingRotation(double rot, double x, double y) {
        AffineTransform at = new AffineTransform();
        at.rotate(rot * Math.PI / 180.0, x, y);
        this.executeDrawingTransform(at, true);
    }

    private void executeDrawingTransform(AffineTransform at, boolean rotation) {
        Iterable<ScriptoriumPoint> points = this.getPoints();
        for (ScriptoriumPoint point : points) {
            Point2D p2D = point.getPoint2D();
            Point2D tP2D = at.transform(p2D, null);
            double x = tP2D.getX();
            point.setX(x);
            double y = tP2D.getY();
            point.setY(y);
        }
        if (rotation) {
            GenericSelectionModel<ScriptoriumShape> shapes = this.getShapesModel();
            for (ScriptoriumShape shape : shapes) {
                AbstractShape<?> abstractShape = shape.getShape();
                Point2D oldAbsolutePosition = this.getAbsoluteLabelPosition(abstractShape);
                Point2D tPosition2D = at.transform(oldAbsolutePosition, null);
                Point2D newRelativePosition = this.getRelativeLabelPosition(abstractShape, tPosition2D);
                abstractShape.setLabelPosition(newRelativePosition);
            }
        }
        this.drawingArea.changeLayout();
        this.drawingArea.repaint();
    }

    @Override
    public Rectangle getBackgroundRectangle(Image bgImage) {
        float w = bgImage.getWidth(null);
        float h = bgImage.getHeight(null);
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(0.0f, h);
        path.lineTo(w, h);
        path.lineTo(w, 0.0f);
        Transform transform = this.getBackgroundTransform();
        AffineTransform at = transform.getTransform(bgImage);
        Shape s = at.createTransformedShape(path);
        Rectangle bounds = s.getBounds();
        return bounds;
    }

    @Override
    public Point2D getBackgroundOrigin(Image bgImage) {
        Rectangle bounds = this.getBackgroundRectangle(bgImage);
        Point2D.Double point = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
        return point;
    }

    @Override
    public void applyTransform() {
        Container parent;
        Image backgroundImage = this.drawingArea.getBackgroundImage();
        if (backgroundImage != null) {
            Rectangle bounds = this.getBackgroundRectangle(backgroundImage);
            Dimension dimension = new Dimension(bounds.width, bounds.height);
            this.drawingArea.setPreferredSize(dimension);
        }
        if ((parent = this.drawingArea.getParent()) != null) {
            parent.doLayout();
        }
        this.drawingArea.repaint();
    }

    @Override
    public void setBackgroundTransform(double xTrans, double yTrans, double mag, double rot) {
        Transform transform = this.drawing.getTransform();
        transform.setXTranslation(xTrans);
        transform.setYTranslation(yTrans);
        transform.setMagnification(mag);
        transform.setRotation(rot);
        this.applyTransform();
        this.setExportableAreaByBackground();
    }

    @Override
    public Transform getBackgroundTransform() {
        return this.drawing.getTransform();
    }

    @Override
    public String getCaption() {
        return this.drawing.getCaption();
    }

    @Override
    public String getDescription() {
        return this.drawing.getDescription();
    }

    @Override
    public void setAttributes(String caption, String description) {
        this.drawing.setCaption(caption);
        this.drawing.setDescription(description);
    }

    @Override
    public BackgroundImage getBackgroundImage() {
        return this.drawing.getBackgroundImage();
    }

    public void setOrigin(int x, int y) {
        this.drawing.setOrigin(x, y);
    }

    public void setDimensions(int width, int height) {
        this.drawing.setDimensions(width, height);
    }

    @Override
    public int newPointId() {
        return this.drawing.newPointId();
    }

    @Override
    public Shape getShape(AbstractShape<?> shape, boolean original) {
        Iterable<ScriptoriumPoint> points = this.getPoints();
        return ShapeAdapter.getShape(shape, points, original);
    }

    @Override
    public List<ScriptoriumPoint> getShapePoints(AbstractShape<?> shape) {
        Iterable<ScriptoriumPoint> points = this.getPoints();
        return ShapeAdapter.getShapePoints(shape, points);
    }

    @Override
    public Point2D getAnchorPosition(AbstractShape<?> shape) {
        return ShapeAdapter.getAnchorPosition(shape, this.getPoints());
    }

    @Override
    public Point2D getAnchorPosition(LabelAnchorType anchorType, AbstractShape<?> shape) {
        return ShapeAdapter.getAnchorPosition(anchorType, shape, this.getPoints());
    }

    @Override
    public Style getStyle(String name) {
        Style style = null;
        Style first = null;
        Iterator<ScriptoriumStyle> styleIterator = this.getStyles();
        while (style == null && styleIterator.hasNext()) {
            Style current = styleIterator.next();
            if (first == null) {
                first = current;
            }
            if (!current.getName().equals(name)) continue;
            style = current;
        }
        if (style == null) {
            style = first == null ? new DefaultStyle() : first;
        }
        return style;
    }

    public Iterator<ScriptoriumStyle> getStyles() {
        this.loadStyles();
        return this.styles.iterator();
    }

    private void loadStyles() {
        if (this.styles == null) {
            StyleSetReference stylesetReference = this.drawing.getStylesetReference();
            EditionManager editionManager = EditionManager.getInstance();
            StyleSet styleset = editionManager.loadStyleset(stylesetReference);
            this.styles = styleset.getStyles();
        }
    }

    @Override
    public Iterable<Shape> getComputedShapes() {
        return new ArrayList<Shape>();
    }
}

