/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.citations;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Reference;
import org.homelinux.elabor.scriptorium.ecomponents.References;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.citations.PropositionChooserFrame;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class CitationPanel
extends ScriptoriumPanel<Citation>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Citation citation;
    private JComboBox<Reference> citationReference;
    private JTextField citationText;
    private JTextField citationProposition;
    private JButton propositionChooserButton;
    private String citationIdString;
    private String citationTextString;
    private String citationPropString;
    private String propChooserButtonString;
    private String propChooserTooltipString;
    DefaultGenericSelectionModel<Reference> references;
    private PropositionChooserFrame propositionChooserFrame;

    public CitationPanel() {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        this.citationReference = new JComboBox();
        this.citationText = new JTextField();
        int fontSize = preferences.getInteger("text_fields_font_size");
        this.citationText.setFont(this.citationText.getFont().deriveFont(fontSize));
        Color protectedBgColor = preferences.getColor("text_fields_protected_bg_color");
        this.citationText.setBackground(protectedBgColor);
        this.citationText.setEditable(false);
        this.citationProposition = new JTextField();
        this.citationProposition.setFont(this.citationProposition.getFont().deriveFont(fontSize));
        this.citationProposition.setBackground(protectedBgColor);
        this.citationProposition.setEditable(false);
        this.propositionChooserButton = UITools.setupButton(this.propChooserButtonString, this.propChooserTooltipString, this, true);
        JLabel citIdLabel = new JLabel(this.citationIdString, 4);
        JLabel citTitLabel = new JLabel(this.citationTextString, 4);
        JLabel citPropLabel = new JLabel(this.citationPropString, 4);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, citIdLabel, 0, 0, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, citTitLabel, 0, 1, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, citPropLabel, 0, 2, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.citationReference, 1, 0, 2, 1, 10, 1, 0, 2);
        UITools.addComponent(this, this.citationText, 1, 1, 2, 1, 10, 1, 2, 2);
        UITools.addComponent(this, this.citationProposition, 1, 2, 1, 1, 10, 1, 2, 2);
        UITools.addComponent(this, this.propositionChooserButton, 2, 2, 1, 1, 1, 1, 0, 2);
    }

    private void initLocale() {
        Class<?> thisClass = this.getClass();
        ClassLoader classLoader = thisClass.getClassLoader();
        String className = thisClass.getName();
        MessageCatalog catalog = new MessageCatalog(classLoader);
        Preferences preferences = Preferences.getInstance();
        String language = preferences.getString("locale");
        catalog.loadCatalog(className, language);
        this.citationIdString = catalog.translate("citationId");
        this.citationTextString = catalog.translate("citationText");
        this.citationPropString = catalog.translate("citationProposition");
        this.propChooserButtonString = catalog.translate("propChooserButton");
        this.propChooserTooltipString = catalog.translate("propChooserTooltip");
    }

    @Override
    public void setup(ScriptoriumDirector director, Citation citation) {
        this.setDirector(director);
        this.citation = citation;
        Edition edition = director.getEdition();
        Header header = edition.getHeader();
        References headerReferences = header.getReferences();
        this.references = new DefaultGenericSelectionModel<Reference>(headerReferences.getReferences());
        this.citationReference.setModel(this.references);
        int index = CitationPanel.getIndex(this.references, this.citation);
        this.citationReference.setSelectedIndex(index);
        this.citationText.setText(this.citation.getValue());
        this.citationProposition.setText(this.citation.getProposition());
    }

    private static int getIndex(DefaultGenericSelectionModel<Reference> references, Citation citation) {
        int index = 0;
        while (index < references.getSize()) {
            if (references.get(index).getId().equals(citation.getId())) break;
            ++index;
        }
        return index < references.getSize() ? index : -1;
    }

    @Override
    public boolean okAction() {
        Reference selected_reference = this.getSelectedReference();
        boolean ok = false;
        if (selected_reference != null) {
            ok = true;
            this.citation.setId(selected_reference.getId());
            this.citation.setProposition(this.citationProposition.getText());
        }
        return ok && super.okAction();
    }

    private void openPropositionChooser() {
        if (this.propositionChooserFrame == null) {
            this.propositionChooserFrame = new PropositionChooserFrame();
        }
        this.propositionChooserFrame.setup(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.propositionChooserButton) {
            this.openPropositionChooser();
        }
    }

    public Reference getSelectedReference() {
        boolean ok;
        Reference selected_reference = null;
        int selected_index = this.citationReference.getSelectedIndex();
        boolean bl = ok = selected_index >= 0;
        if (ok) {
            selected_reference = this.references.get(selected_index);
        }
        return selected_reference;
    }

    public void setProposition(int index) {
        if (index >= 0) {
            this.citationProposition.setText(String.valueOf(index));
        } else {
            this.citationProposition.setText("");
        }
    }

    public int getProposition() {
        int index;
        try {
            index = Integer.parseInt(this.citationProposition.getText());
        }
        catch (NumberFormatException exc) {
            index = -1;
        }
        return index;
    }
}

