/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.visitors;

import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Crux;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Expunctio;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Formula;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.ecomponents.Integratio;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.Quadratus;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.Rectangulus;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.NullEditionVisitor;
import org.homelinux.elabor.scriptorium.ndraft.actions.AxisAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineDirectionAction;

public class EditionComponentFinder
extends NullEditionVisitor {
    private int offset;
    private int position;
    private EditionComponent<?> foundComponent;

    public EditionComponent<?> getComponent() {
        return this.foundComponent;
    }

    private boolean found() {
        return this.position >= this.offset;
    }

    private void defaultVisit(EditionComponent<?> node) {
        List<EditionComponent<?>> children = node.getChildrenForTextView();
        if (children != null) {
            for (EditionComponent<?> child : children) {
                child.accept(this);
                if (!this.found()) continue;
                this.foundComponent = child;
                break;
            }
        }
    }

    public void setTarget(int offset) {
        this.offset = offset;
        this.position = 0;
        this.foundComponent = null;
    }

    @Override
    public void visit(Edition edition) {
        Content content = edition.getContent();
        content.accept(this);
    }

    @Override
    public void visit(Content content) {
        this.defaultVisit(content);
    }

    private void visitDelimitedComponent(EditionComponent<?> component) {
        ++this.position;
        for (EditionComponent<?> child : component.getChildrenForTextView()) {
            child.accept(this);
        }
        ++this.position;
        if (this.position == this.offset) {
            ++this.offset;
        }
        if (this.found()) {
            this.foundComponent = component;
        }
    }

    @Override
    public void visit(Expunctio expunctio) {
        this.visitDelimitedComponent(expunctio);
    }

    @Override
    public void visit(Crux crux) {
        this.visitDelimitedComponent(crux);
    }

    @Override
    public void visit(Variant variant) {
        this.visitDelimitedComponent(variant);
    }

    @Override
    public void visit(VariantItem variant_item) {
        this.defaultVisit(variant_item);
    }

    @Override
    public void visit(Reading reading) {
        this.defaultVisit(reading);
    }

    @Override
    public void visit(Name name) {
        this.defaultVisit(name);
    }

    @Override
    public void visit(Place place) {
        this.defaultVisit(place);
    }

    @Override
    public void visit(Tongue tongue) {
        this.defaultVisit(tongue);
    }

    @Override
    public void visit(MathConcept mathConcept) {
        this.defaultVisit(mathConcept);
    }

    @Override
    public void visit(DateToken date) {
        this.defaultVisit(date);
    }

    @Override
    public void visit(Enunciatio enunciatio) {
        this.defaultVisit(enunciatio);
    }

    @Override
    public void visit(Formula formula) {
        this.defaultVisit(formula);
    }

    @Override
    public void visit(Citation citation) {
        this.defaultVisit(citation);
    }

    @Override
    public void visit(Text text) {
        this.position += text.getTextLength();
    }

    private void visitNonValuedToken(EditionComponent<?> component) {
        ++this.position;
        if (this.found()) {
            this.foundComponent = component;
        }
    }

    @Override
    public void visit(Drawing drawing) {
        this.visitNonValuedToken(drawing);
    }

    @Override
    public void visit(Unit unit) {
        this.visitNonValuedToken(unit);
    }

    @Override
    public void visit(TextPart part) {
        this.visitNonValuedToken(part);
    }

    @Override
    public void visit(Folium folium) {
        this.visitNonValuedToken(folium);
    }

    @Override
    public void visit(Quadratus quadratus) {
        this.visitNonValuedToken(quadratus);
    }

    @Override
    public void visit(Rectangulus rectangulus) {
        this.visitNonValuedToken(rectangulus);
    }

    @Override
    public void visit(Integratio integratio) {
        this.visitNonValuedToken(integratio);
    }

    @Override
    public void visit(Comment comment) {
        this.visitNonValuedToken(comment);
    }

    @Override
    public void visit(Annotation annotation) {
        this.visitNonValuedToken(annotation);
    }

    @Override
    public void visit(Image image) {
        this.visitNonValuedToken(image);
    }

    @Override
    public void visit(ScriptoriumShape shape) {
        this.defaultVisit(shape);
    }

    @Override
    public void visit(ScriptoriumStyle scriptoriumStyle) {
        this.defaultVisit(scriptoriumStyle);
    }

    @Override
    public void visit(Work work) {
        this.defaultVisit(work);
    }

    @Override
    public void visit(AxisAction straightLineAction) {
    }

    @Override
    public void visit(StraightLineAction straightLineAction) {
    }

    @Override
    public void visit(StraightLineDirectionAction straightLineDirectionAction) {
    }
}

