/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;

public class Equation {
    private final boolean ellipse;
    private final boolean hyperbola;
    private double xc;
    private double yc;
    private double alpha;
    private double semiMajor;
    private double semiMinor;
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;

    public Equation(double a, double b, double c, double d, double e, double f) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        this.f = f;
        double discr = b * b - 4.0 * a * c;
        if (Math.abs(discr) < 1.0E-8) {
            this.ellipse = false;
            this.hyperbola = false;
        } else {
            this.xc = -(b * e - 2.0 * c * d) / discr;
            this.yc = -(b * d - 2.0 * a * e) / discr;
            double tan = b / (a - c);
            this.alpha = Math.atan(tan);
            this.alpha = a == c ? 0.0 : (a < c ? (this.alpha /= 2.0) : (this.alpha + Math.PI) / 2.0);
            if (discr < 0.0) {
                this.ellipse = true;
                this.hyperbola = false;
                double cos = Math.cos(this.alpha);
                double sin = Math.sin(this.alpha);
                double F = a * this.xc * this.xc + b * this.xc * this.yc + c * this.yc * this.yc + d * this.xc + e * this.yc + f;
                double semi1 = Math.sqrt(-F / (a * cos * cos + b * sin * cos + c * sin * sin));
                double semi2 = Math.sqrt(-F / (a * sin * sin - b * sin * cos + c * cos * cos));
                this.semiMajor = Math.max(semi1, semi2);
                this.semiMinor = Math.min(semi1, semi2);
            } else {
                this.ellipse = false;
                this.hyperbola = true;
            }
        }
    }

    public boolean isEllipse() {
        return this.ellipse;
    }

    public double getXc() {
        return this.xc;
    }

    public double getYc() {
        return this.yc;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getSemiMajor() {
        return this.semiMajor;
    }

    public double getSemiMinor() {
        return this.semiMinor;
    }

    public AffineTransform getTransform() {
        AffineTransform transform = new AffineTransform();
        transform.translate(this.xc, this.yc);
        transform.rotate(this.alpha);
        transform.scale(this.semiMajor, this.semiMinor);
        return transform;
    }

    public boolean isHyperbola() {
        return this.hyperbola;
    }

    public DraftVector tangent(Point2D point) {
        double x = point.getX();
        double y = point.getY();
        double f1 = 2.0 * this.a * x + this.b * y + this.d;
        double f2 = this.b * x + 2.0 * this.c * y + this.e;
        return new DraftVector(point, f2, -f1);
    }

    public double value(Point2D point) {
        double x = point.getX();
        double y = point.getY();
        return this.a * x * x + this.b * x * y + this.c * y * y + this.d * x + this.e * y + this.f;
    }
}

