/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitor;
import org.homelinux.elabor.tools.MessageCatalog;
import org.w3c.dom.Element;

public class Bezier
extends AbstractShape<Bezier>
implements ComponentFactory<Bezier> {
    private String startString;
    private String endString;
    private String control1String;
    private String control2String;
    private String[] pointNames;

    public Bezier() {
        this.initLocale();
    }

    public Bezier(Element element) {
        super(element);
        this.initLocale();
    }

    public Bezier(ScriptoriumShape parent, EditionListener listener) {
        super(parent, listener);
        this.initLocale();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.startString = catalog.translate("start");
        this.endString = catalog.translate("end");
        this.control1String = catalog.translate("control1");
        this.control2String = catalog.translate("control2");
        this.pointNames = new String[]{this.startString, this.endString, this.control1String, this.control2String};
    }

    @Override
    public int getNeededNumberOfPoints() {
        return this.pointNames.length;
    }

    @Override
    public String getPointName(int position) {
        return this.pointNames[position];
    }

    @Override
    public Shape getShape(Point2D[] points) {
        CubicCurve2D.Double bezier = new CubicCurve2D.Double();
        bezier.setCurve(points[0], points[2], points[3], points[1]);
        return bezier;
    }

    @Override
    public String getElementName() {
        return ComponentType.BEZIER.getName();
    }

    @Override
    public Bezier make(Element element) {
        return new Bezier(element);
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }
}

