/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionLeaf;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public class Transform
extends EditionLeaf<Transform>
implements ComponentFactory<Transform> {
    private static final String magnification_name = "magnification";
    private static final String x_translation_name = "x_translation";
    private static final String y_translation_name = "y_translation";
    private static final String rotation_name = "rotation";

    public Transform() {
    }

    public Transform(EditionComponent<?> parent, EditionListener listener) {
        super(parent);
        this.initialise();
        this.setListener(listener);
    }

    public Transform(Element element) {
        super(element);
    }

    @Override
    protected void initialise() {
        super.initialise();
        this.setMagnification(1.0);
        this.setXTranslation(0.0);
        this.setYTranslation(0.0);
        this.setRotation(0.0);
    }

    public void setMagnification(double magnification) {
        this.setDoubleAttribute(magnification_name, magnification);
    }

    public double getMagnification() {
        return this.getDoubleAttribute(magnification_name);
    }

    public void setXTranslation(double x_translation) {
        this.setDoubleAttribute(x_translation_name, x_translation);
    }

    public double getXTranslation() {
        return this.getDoubleAttribute(x_translation_name);
    }

    public void setYTranslation(double y_translation) {
        this.setDoubleAttribute(y_translation_name, y_translation);
    }

    public double getYTranslation() {
        return this.getDoubleAttribute(y_translation_name);
    }

    public void setRotation(double rotation) {
        this.setDoubleAttribute(rotation_name, rotation);
    }

    public double getRotation() {
        return this.getDoubleAttribute(rotation_name);
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        String to_string = "transform: ";
        to_string = String.valueOf(to_string) + this.getMagnification() + " " + this.getXTranslation() + " " + this.getYTranslation() + " " + this.getRotation();
        return to_string;
    }

    @Override
    public Transform make(Element element) {
        return new Transform(element);
    }

    @Override
    public String getElementName() {
        return ComponentType.TRANSFORM.getName();
    }

    public AffineTransform getTransform(Image image) {
        double h;
        double w;
        if (image == null) {
            w = 0.0;
            h = 0.0;
        } else {
            w = image.getWidth(null);
            h = image.getHeight(null);
        }
        AffineTransform t = new AffineTransform();
        t.translate(this.getXTranslation(), this.getYTranslation());
        t.scale(this.getMagnification(), this.getMagnification());
        t.rotate(this.getRotation() * Math.PI / 180.0, w / 2.0, h / 2.0);
        return t;
    }
}

