/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.Description;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public class VariantItem
extends EditionComposite<VariantItem>
implements ComponentFactory<VariantItem> {
    public VariantItem() {
    }

    public VariantItem(Variant parent) {
        super(parent);
    }

    public VariantItem(Element element) {
        super(element);
    }

    public void setReadingValue(String value) {
        Reading reading = this.getReading();
        Text text = new Text(this);
        text.setValue(value);
        reading.setContent(text);
    }

    public String getReadingValue() {
        return this.getReading().toString();
    }

    public Reading getReading() {
        return this.getOrCreateFirstNodeByType(new Reading());
    }

    public List<Description> getDescriptions() {
        return this.getNodesByType(new Description());
    }

    public void addDescription(Description description) {
        this.addChild(description);
    }

    public void removeDescription(Description description) {
        this.removeChild(description);
    }

    public void replaceDescription(Description old_description, Description new_description) {
        this.replaceChild(old_description, new_description);
    }

    @Override
    public String toString() {
        Reading reading = this.getReading();
        String reading_value = reading == null ? "" : reading.toString();
        String description_value = "";
        List<Description> descriptions = this.getDescriptions();
        for (Description description : descriptions) {
            description_value = String.valueOf(description_value) + (description_value.length() == 0 ? "" : " ") + description.toString();
        }
        return String.valueOf(reading_value) + description_value;
    }

    @Override
    public List<EditionComponent<?>> getChildrenForTextView() {
        ArrayList nodes = new ArrayList();
        Reading reading = this.getReading();
        nodes.add(reading);
        return nodes;
    }

    protected boolean referOntology(OntologyClass ontology_class) {
        boolean refer = false;
        for (Description item : this.getDescriptions()) {
            refer = item.referOntology(ontology_class);
            if (refer) break;
        }
        return refer;
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @Deprecated
    public VariantItem make(Element element) {
        return new VariantItem(element);
    }

    @Override
    public String getElementName() {
        return "variantitem";
    }
}

