/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.batik.svggen.SVGGraphics2D;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.LoadStylesException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSet;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingArea;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingAreaMouseListener;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.ExportDrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.operations.ExportDirectorFactory;
import org.homelinux.elabor.ui.UIConstants;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EditionStreamer {
    private static final String SVG_NS = "http://www.w3.org/2000/svg";
    private static final int OFFSET = 10;
    private DocumentBuilder builder;
    private DocumentBuilderFactory factory;
    private String releaseNumber;

    public EditionStreamer(String releaseNumber) {
        this.releaseNumber = releaseNumber;
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setValidating(false);
        this.factory.setIgnoringElementContentWhitespace(true);
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.builder;
    }

    public Edition load(File edition_file) throws SAXException, IOException {
        Edition edition = new Edition();
        Document document = this.loadDOMTree(edition_file);
        if (document != null) {
            edition.setDomDocument(document);
            edition.setFile(edition_file);
        }
        return edition;
    }

    private Document loadDOMTree(File file) throws SAXException, IOException {
        Document document = this.getDocumentBuilder().parse(file);
        EditionStreamer.cleanOldEdition(document);
        return document;
    }

    private static void cleanOldEdition(Document document) {
        Element documentElement = document.getDocumentElement();
        NamedNodeMap attributes = documentElement.getAttributes();
        ArrayList<String> delenda = new ArrayList<String>();
        int index = 0;
        while (index < attributes.getLength()) {
            Node node = attributes.item(index);
            String nodeName = node.getNodeName();
            delenda.add(nodeName);
            ++index;
        }
        for (String nodeName : delenda) {
            documentElement.removeAttribute(nodeName);
        }
    }

    public File save(Edition edition) throws FileNotFoundException, TransformerException {
        edition.setReleaseNumber(this.releaseNumber);
        Document document = edition.getDocument();
        File file = edition.getFile();
        return EditionStreamer.save(document, file);
    }

    public static File save(Document document, File file) throws FileNotFoundException, TransformerException {
        if (file.exists()) {
            File backup_file = new File(String.valueOf(file.getPath()) + "~");
            file.renameTo(backup_file);
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintStream printStream = new PrintStream(file);){
            EditionStreamer.saveDOM(document, null, printStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }

    public static void saveDOM(Document document, Source style, OutputStream out) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = style == null ? tf.newTransformer() : tf.newTransformer(style);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
    }

    public static void export(Edition edition, URL style, String extention) throws TransformerException, IOException {
        File file = edition.getFile();
        String path = file.getPath();
        String out_filename = path.concat(extention);
        File html_file = new File(out_filename);
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            PrintStream out = new PrintStream(html_file);
            try {
                try (InputStream stream = style.openStream();){
                    StreamSource style_source = new StreamSource(stream);
                    Document document = edition.getDocument();
                    EditionStreamer.saveDOM(document, style_source, out);
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void exportSvg(Edition edition, ExportDirectorFactory exportDirectorFactory) {
        Content content = edition.getContent();
        List<Drawing> drawings = content.getDrawings();
        if (drawings.size() >= 1) {
            Drawing drawing = drawings.get(0);
            File docFile = edition.getFile();
            this.exportSvg(drawing, docFile, exportDirectorFactory);
        }
    }

    private void exportSvg(Drawing drawing, File docFile, ExportDirectorFactory exportDirectorFactory) {
        int width = drawing.getWidth();
        int height = drawing.getHeight();
        DrawingArea drawingArea = new DrawingArea(new DrawingAreaMouseListener(), false, true);
        drawingArea.setSize(width + 20, height + 20);
        drawingArea.setShowLabels(true);
        List<ExportDrawingDirector> directors = exportDirectorFactory.buildDrawingDirectors(drawing, drawingArea);
        for (ExportDrawingDirector drawingDirector : directors) {
            String filePath = drawingDirector.getPath(docFile);
            this.exportSingleSvg(drawingArea, drawingDirector, filePath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportSingleSvg(DrawingArea drawingArea, DrawingDirector drawingDirector, String filePath) {
        drawingArea.setup(drawingDirector);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileOutputStream imageStream = new FileOutputStream(filePath);
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)imageStream, "UTF8");){
                        DOMImplementation domImplementation = this.builder.getDOMImplementation();
                        Document document = domImplementation.createDocument(SVG_NS, "svg", null);
                        SVGGraphics2D graphics = new SVGGraphics2D(document);
                        drawingArea.export(graphics);
                        graphics.stream((Writer)writer);
                        graphics.dispose();
                    }
                    if (imageStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (imageStream == null) throw throwable;
                    imageStream.close();
                    throw throwable;
                }
                imageStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException exc) {
            String localizedMessage = exc.getLocalizedMessage();
            UIConstants uiConstants = UIConstants.getInstance();
            JOptionPane.showMessageDialog(null, localizedMessage, uiConstants.errorString, 0);
        }
    }

    public StyleSet loadStyleset(File file) {
        StyleSet styleset;
        try {
            Element element;
            this.builder = this.factory.newDocumentBuilder();
            if (file != null && file.isFile()) {
                Document document = this.builder.parse(file);
                element = document.getDocumentElement();
            } else {
                Document document = this.builder.newDocument();
                element = document.createElement("styleset");
                document.appendChild(element);
            }
            styleset = new StyleSet(element);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoadStylesException();
        }
        return styleset;
    }
}

