/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.TextNotFoundException;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionComponentFinder;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.NodeOffsetFinder;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.TextNodeFinder;

public class EditionMapper {
    private Edition edition;
    private TextNodeFinder textFinder;
    private NodeOffsetFinder offsetFinder;
    private EditionComponentFinder componentFinder;

    public EditionMapper(Edition edition) {
        this.edition = edition;
        this.textFinder = new TextNodeFinder();
        this.offsetFinder = new NodeOffsetFinder();
        this.componentFinder = new EditionComponentFinder();
    }

    public Text getTextByOffset(int offset) throws TextNotFoundException {
        this.textFinder.setTarget(offset);
        this.textFinder.visit(this.edition);
        return this.textFinder.getComponent();
    }

    public int getComponentOffset(EditionComponent<?> node) {
        this.offsetFinder.setTarget(node);
        this.offsetFinder.visit(this.edition);
        return this.offsetFinder.getOffset();
    }

    public EditionComponent<?> getComponentByOffset(int offset) {
        this.componentFinder.setTarget(offset);
        this.componentFinder.visit(this.edition);
        return this.componentFinder.getComponent();
    }
}

