/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.definers;

import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import org.homelinux.elabor.scriptorium.definers.DefinerStrategy;
import org.homelinux.elabor.scriptorium.definers.InvalidTokenDefinition;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumStyledDocument;
import org.homelinux.elabor.ui.UIConstants;

public class DelimitedTokenDecorator<eC extends EditionComponent<?>>
implements DefinerStrategy<eC> {
    private DefinerStrategy<eC> strategy;
    private String left_delimiter;
    private String right_delimiter;

    public DelimitedTokenDecorator(DefinerStrategy<eC> strategy, String left_delimiter, String right_delimiter) {
        this.strategy = strategy;
        this.left_delimiter = left_delimiter;
        this.right_delimiter = right_delimiter;
    }

    @Override
    public eC defineToken(int offset, int length, ScriptoriumDirector director, ComponentFactory<eC> prototype) throws InvalidTokenDefinition {
        eC token = this.strategy.defineToken(offset, length, director, prototype);
        this.addDelimiters(offset, director, token);
        return token;
    }

    private void addDelimiters(int offset, ScriptoriumDirector director, eC token) {
        ScriptoriumStyledDocument document = director.getStyledDocument();
        document.removeDocumentListener(document);
        if (token != null) {
            try {
                document.insertString(offset + ((EditionComponent)token).getTextLength(), this.right_delimiter, document.getStyle("normal"));
                document.insertString(offset, this.left_delimiter, document.getStyle("normal"));
            }
            catch (BadLocationException e) {
                System.err.println(e.getLocalizedMessage());
                JOptionPane.showMessageDialog(null, String.valueOf(UIConstants.getInstance().internalErrorString) + ": " + e.getLocalizedMessage(), UIConstants.getInstance().errorString, 0);
            }
        }
        document.addDocumentListener(document);
    }
}

