/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;

public class ParagraphBorderEvent
extends PdfPageEventHelper {
    private boolean active = false;
    private boolean rounded = false;
    private float startPosition;
    private float width = 0.0f;
    private double lineWidth = 1.0;

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setRounded(boolean rounded) {
        this.rounded = rounded;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {
        this.startPosition = paragraphPosition;
    }

    public void onParagraphEnd(PdfWriter writer, Document document, float paragraphPosition) {
        if (this.active) {
            float parWidth;
            PdfContentByte cb = writer.getDirectContentUnder();
            float left = document.left();
            float right = document.right();
            float f = parWidth = this.width == 0.0f ? right - left : this.width;
            if (this.rounded) {
                cb.setLineWidth(this.lineWidth);
                cb.roundRectangle(left - 5.0f + (right - left - parWidth), paragraphPosition - 5.0f, parWidth + 10.0f, this.startPosition - paragraphPosition + 5.0f, 5.0f);
            } else {
                cb.rectangle(left - 5.0f, paragraphPosition - 5.0f, right - left + 10.0f, this.startPosition - paragraphPosition + 5.0f);
            }
            cb.stroke();
        }
    }
}

