/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.dom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DomIterator
implements Iterator<Element> {
    private String pattern;
    private Element element;

    public DomIterator(Node node, String pattern) {
        this.pattern = pattern;
        Node child = node.getFirstChild();
        this.next(child);
    }

    private void next(Node child) {
        Node current;
        for (current = child; current != null; current = current.getNextSibling()) {
            String nodeName;
            if (current.getNodeType() != 1 || !this.match(nodeName = current.getNodeName())) continue;
            this.element = (Element)current;
            break;
        }
        if (current == null) {
            this.element = null;
        }
    }

    private boolean match(String nodeName) {
        String nsNodeName;
        if (this.pattern.contains(":")) {
            nsNodeName = nodeName;
        } else {
            int index = nodeName.indexOf(58);
            nsNodeName = nodeName.substring(index + 1);
        }
        return nsNodeName.matches(this.pattern);
    }

    @Override
    public boolean hasNext() {
        return this.element != null;
    }

    @Override
    public Element next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Element next = this.element;
        Node nextSibling = this.element.getNextSibling();
        this.next(nextSibling);
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

