select mno.* from (
	SELECT
		mno.*,
		row_number() over (ORDER BY
			DATA_MISURA DESC,
			DATA_PUBBLICAZIONE_FILE DESC,
			DATA_IMPORT_FILE DESC,
			ID DESC) as seqnum
	FROM misure_pod_non_orari mno
	WHERE
		pod_id = :codice_pod: AND
		(
			cod_flusso IN ('VNO','VNO2G','SMIS','RNO','RNO2G','RNV','RNV2G') OR
			(cod_flusso IN ('PNO','PNO2G') AND TIPO_DATO in (:tipi:))
		) AND
		TO_CHAR(data_misura, 'YYYY-MM-DD') = :data: AND
		STATO IN (6,7) AND NOT (STATO=7 AND COD_ERRORE=1070)
) mno where seqnum=1
