/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.freemarker;

import freemarker.core.ParseException;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.AllHttpScopesHashModel;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMarkerView
extends AbstractTemplateView {
    private String encoding;
    private Configuration configuration;
    private TaglibFactory taglibFactory;
    private ServletContextHashModel servletContextHashModel;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void initServletContext(ServletContext servletContext) throws BeansException {
        if (this.getConfiguration() != null) {
            this.taglibFactory = new TaglibFactory(servletContext);
        } else {
            FreeMarkerConfig config = this.autodetectConfiguration();
            this.setConfiguration(config.getConfiguration());
            this.taglibFactory = config.getTaglibFactory();
        }
        GenericServletAdapter servlet = new GenericServletAdapter();
        try {
            servlet.init(new DelegatingServletConfig());
        }
        catch (ServletException ex) {
            throw new BeanInitializationException("Initialization of GenericServlet adapter failed", ex);
        }
        this.servletContextHashModel = new ServletContextHashModel((GenericServlet)servlet, this.getObjectWrapper());
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        try {
            return BeanFactoryUtils.beanOfTypeIncludingAncestors(this.getApplicationContext(), FreeMarkerConfig.class, true, false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this web application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", ex);
        }
    }

    protected ObjectWrapper getObjectWrapper() {
        ObjectWrapper ow = this.getConfiguration().getObjectWrapper();
        return ow != null ? ow : ObjectWrapper.DEFAULT_WRAPPER;
    }

    @Override
    public boolean checkResource(Locale locale) throws Exception {
        try {
            this.getTemplate(this.getUrl(), locale);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No FreeMarker view found for URL: " + this.getUrl());
            }
            return false;
        }
        catch (ParseException ex) {
            throw new ApplicationContextException("Failed to parse FreeMarker template for URL [" + this.getUrl() + "]", ex);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Could not load FreeMarker template for URL [" + this.getUrl() + "]", ex);
        }
    }

    @Override
    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeHelpers(model, request);
        this.doRender(model, request, response);
    }

    protected void exposeHelpers(Map<String, Object> model, HttpServletRequest request) throws Exception {
    }

    protected void doRender(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        SimpleHash fmModel = this.buildTemplateModel(model, request, response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rendering FreeMarker template [" + this.getUrl() + "] in FreeMarkerView '" + this.getBeanName() + "'");
        }
        Locale locale = RequestContextUtils.getLocale(request);
        this.processTemplate(this.getTemplate(locale), fmModel, response);
    }

    protected SimpleHash buildTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        AllHttpScopesHashModel fmModel = new AllHttpScopesHashModel(this.getObjectWrapper(), this.getServletContext(), request);
        fmModel.put("JspTaglibs", (Object)this.taglibFactory);
        fmModel.put("Application", (Object)this.servletContextHashModel);
        fmModel.put("Session", (Object)this.buildSessionModel(request, response));
        fmModel.put("Request", (Object)new HttpRequestHashModel(request, response, this.getObjectWrapper()));
        fmModel.put("RequestParameters", (Object)new HttpRequestParametersHashModel(request));
        fmModel.putAll(model);
        return fmModel;
    }

    private HttpSessionHashModel buildSessionModel(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return new HttpSessionHashModel(session, this.getObjectWrapper());
        }
        return new HttpSessionHashModel(null, request, response, this.getObjectWrapper());
    }

    protected Template getTemplate(Locale locale) throws IOException {
        return this.getTemplate(this.getUrl(), locale);
    }

    protected Template getTemplate(String name, Locale locale) throws IOException {
        return this.getEncoding() != null ? this.getConfiguration().getTemplate(name, locale, this.getEncoding()) : this.getConfiguration().getTemplate(name, locale);
    }

    protected void processTemplate(Template template, SimpleHash model, HttpServletResponse response) throws IOException, TemplateException {
        template.process((Object)model, (Writer)response.getWriter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        @Override
        public String getServletName() {
            return FreeMarkerView.this.getBeanName();
        }

        @Override
        public ServletContext getServletContext() {
            return FreeMarkerView.this.getServletContext();
        }

        @Override
        public String getInitParameter(String paramName) {
            return null;
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(new HashSet());
        }
    }

    private static class GenericServletAdapter
    extends GenericServlet {
        private GenericServletAdapter() {
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }
    }
}

