/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.util.StringUtils;

public abstract class AbstractGenericContextLoader
extends AbstractContextLoader {
    protected static final Log logger = LogFactory.getLog(AbstractGenericContextLoader.class);

    public final ConfigurableApplicationContext loadContext(String ... locations) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading ApplicationContext for locations [" + StringUtils.arrayToCommaDelimitedString(locations) + "].");
        }
        GenericApplicationContext context = new GenericApplicationContext();
        this.prepareContext(context);
        this.customizeBeanFactory(context.getDefaultListableBeanFactory());
        this.createBeanDefinitionReader(context).loadBeanDefinitions(locations);
        AnnotationConfigUtils.registerAnnotationConfigProcessors(context);
        this.customizeContext(context);
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    protected void prepareContext(GenericApplicationContext context) {
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
    }

    protected abstract BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext var1);

    protected void customizeContext(GenericApplicationContext context) {
    }
}

