/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.method;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.AbstractMethodSecurityMetadataSource;
import org.springframework.security.access.method.MethodSecurityMetadataSource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegatingMethodSecurityMetadataSource
extends AbstractMethodSecurityMetadataSource
implements InitializingBean {
    private static final List<ConfigAttribute> NULL_CONFIG_ATTRIBUTE = Collections.emptyList();
    private List<MethodSecurityMetadataSource> methodSecurityMetadataSources;
    private final Map<DefaultCacheKey, Collection<ConfigAttribute>> attributeCache = new HashMap<DefaultCacheKey, Collection<ConfigAttribute>>();

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.methodSecurityMetadataSources, "A list of MethodSecurityMetadataSources is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ConfigAttribute> getAttributes(Method method, Class<?> targetClass) {
        DefaultCacheKey cacheKey = new DefaultCacheKey(method, targetClass);
        Map<DefaultCacheKey, Collection<ConfigAttribute>> map = this.attributeCache;
        synchronized (map) {
            MethodSecurityMetadataSource s2;
            Collection<ConfigAttribute> cached = this.attributeCache.get(cacheKey);
            if (cached == NULL_CONFIG_ATTRIBUTE) {
                return null;
            }
            if (cached != null) {
                return cached;
            }
            Collection<ConfigAttribute> attributes = null;
            Iterator<MethodSecurityMetadataSource> i$ = this.methodSecurityMetadataSources.iterator();
            while (i$.hasNext() && (attributes = (s2 = i$.next()).getAttributes(method, targetClass)) == null) {
            }
            if (attributes == null) {
                this.attributeCache.put(cacheKey, NULL_CONFIG_ATTRIBUTE);
                return null;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding security method [" + cacheKey + "] with attributes " + attributes);
            }
            this.attributeCache.put(cacheKey, attributes);
            return attributes;
        }
    }

    @Override
    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> set = new HashSet<ConfigAttribute>();
        for (MethodSecurityMetadataSource s2 : this.methodSecurityMetadataSources) {
            Collection<ConfigAttribute> attrs = s2.getAllConfigAttributes();
            if (attrs == null) continue;
            set.addAll(attrs);
        }
        return set;
    }

    public void setMethodSecurityMetadataSources(List methodSecurityMetadataSources) {
        this.methodSecurityMetadataSources = methodSecurityMetadataSources;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultCacheKey {
        private final Method method;
        private final Class<?> targetClass;

        public DefaultCacheKey(Method method, Class<?> targetClass) {
            this.method = method;
            this.targetClass = targetClass;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultCacheKey)) {
                return false;
            }
            DefaultCacheKey otherKey = (DefaultCacheKey)other;
            return this.method.equals(otherKey.method) && ObjectUtils.nullSafeEquals(this.targetClass, otherKey.targetClass);
        }

        public int hashCode() {
            return this.method.hashCode() * 21 + (this.targetClass != null ? this.targetClass.hashCode() : 0);
        }

        public String toString() {
            return "CacheKey[" + (this.targetClass == null ? "-" : this.targetClass.getName()) + "; " + this.method + "]";
        }
    }
}

