/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.net.URI;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeaders
implements MultiValueMap<String, String> {
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_CHARSET = "Accept-Charset";
    private static final String ALLOW = "Allow";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String DATE = "Date";
    private static final String ETAG = "ETag";
    private static final String EXPIRES = "Expires";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String LOCATION = "Location";
    private static final String PRAGMA = "Pragma";
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy"};
    private static TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final Map<String, List<String>> headers;

    private HttpHeaders(Map<String, List<String>> headers, boolean readOnly) {
        Assert.notNull(headers, "'headers' must not be null");
        if (readOnly) {
            LinkedCaseInsensitiveMap<List<String>> map = new LinkedCaseInsensitiveMap<List<String>>(headers.size(), Locale.ENGLISH);
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                List<String> values = Collections.unmodifiableList(entry.getValue());
                map.put(entry.getKey(), values);
            }
            this.headers = Collections.unmodifiableMap(map);
        } else {
            this.headers = headers;
        }
    }

    public HttpHeaders() {
        this(new LinkedCaseInsensitiveMap<List<String>>(8, Locale.ENGLISH), false);
    }

    public static HttpHeaders readOnlyHttpHeaders(HttpHeaders headers) {
        return new HttpHeaders(headers, true);
    }

    public void setAccept(List<MediaType> acceptableMediaTypes) {
        this.set(ACCEPT, MediaType.toString(acceptableMediaTypes));
    }

    public List<MediaType> getAccept() {
        String value = this.getFirst(ACCEPT);
        return value != null ? MediaType.parseMediaTypes(value) : Collections.emptyList();
    }

    public void setAcceptCharset(List<Charset> acceptableCharsets) {
        StringBuilder builder = new StringBuilder();
        Iterator<Charset> iterator = acceptableCharsets.iterator();
        while (iterator.hasNext()) {
            Charset charset = iterator.next();
            builder.append(charset.name().toLowerCase(Locale.ENGLISH));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        this.set(ACCEPT_CHARSET, builder.toString());
    }

    public List<Charset> getAcceptCharset() {
        ArrayList<Charset> result = new ArrayList<Charset>();
        String value = this.getFirst(ACCEPT_CHARSET);
        if (value != null) {
            String[] tokens;
            String[] stringArray = tokens = value.split(",\\s*");
            int n2 = tokens.length;
            int n3 = 0;
            while (n3 < n2) {
                String token = stringArray[n3];
                int paramIdx = token.indexOf(59);
                if (paramIdx == -1) {
                    result.add(Charset.forName(token));
                } else {
                    result.add(Charset.forName(token.substring(0, paramIdx)));
                }
                ++n3;
            }
        }
        return result;
    }

    public void setAllow(Set<HttpMethod> allowedMethods) {
        this.set(ALLOW, StringUtils.collectionToCommaDelimitedString(allowedMethods));
    }

    public Set<HttpMethod> getAllow() {
        String value = this.getFirst(ALLOW);
        if (value != null) {
            String[] tokens;
            ArrayList<HttpMethod> allowedMethod = new ArrayList<HttpMethod>(5);
            String[] stringArray = tokens = value.split(",\\s*");
            int n2 = tokens.length;
            int n3 = 0;
            while (n3 < n2) {
                String token = stringArray[n3];
                allowedMethod.add(HttpMethod.valueOf(token));
                ++n3;
            }
            return EnumSet.copyOf(allowedMethod);
        }
        return EnumSet.noneOf(HttpMethod.class);
    }

    public void setCacheControl(String cacheControl) {
        this.set(CACHE_CONTROL, cacheControl);
    }

    public String getCacheControl() {
        return this.getFirst(CACHE_CONTROL);
    }

    public void setContentDispositionFormData(String name, String filename) {
        Assert.notNull(name, "'name' must not be null");
        StringBuilder builder = new StringBuilder("form-data; name=\"");
        builder.append(name).append('\"');
        if (filename != null) {
            builder.append("; filename=\"");
            builder.append(filename).append('\"');
        }
        this.set(CONTENT_DISPOSITION, builder.toString());
    }

    public void setContentLength(long contentLength) {
        this.set(CONTENT_LENGTH, Long.toString(contentLength));
    }

    public long getContentLength() {
        String value = this.getFirst(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setContentType(MediaType mediaType) {
        Assert.isTrue(!mediaType.isWildcardType(), "'Content-Type' cannot contain wildcard type '*'");
        Assert.isTrue(!mediaType.isWildcardSubtype(), "'Content-Type' cannot contain wildcard subtype '*'");
        this.set(CONTENT_TYPE, mediaType.toString());
    }

    public MediaType getContentType() {
        String value = this.getFirst(CONTENT_TYPE);
        return value != null ? MediaType.parseMediaType(value) : null;
    }

    public void setDate(long date) {
        this.setDate(DATE, date);
    }

    public long getDate() {
        return this.getFirstDate(DATE);
    }

    public void setETag(String eTag) {
        this.set(ETAG, this.quote(eTag));
    }

    public String getETag() {
        return this.unquote(this.getFirst(ETAG));
    }

    public void setExpires(long expires) {
        this.setDate(EXPIRES, expires);
    }

    public long getExpires() {
        return this.getFirstDate(EXPIRES);
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.setDate(IF_MODIFIED_SINCE, ifModifiedSince);
    }

    public long getIfNotModifiedSince() {
        return this.getFirstDate(IF_MODIFIED_SINCE);
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.set(IF_NONE_MATCH, this.quote(ifNoneMatch));
    }

    public void setIfNoneMatch(List<String> ifNoneMatchList) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = ifNoneMatchList.iterator();
        while (iterator.hasNext()) {
            String ifNoneMatch = iterator.next();
            builder.append(this.quote(ifNoneMatch));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        this.set(IF_NONE_MATCH, builder.toString());
    }

    public List<String> getIfNoneMatch() {
        ArrayList<String> result = new ArrayList<String>();
        String value = this.getFirst(IF_NONE_MATCH);
        if (value != null) {
            String[] tokens;
            String[] stringArray = tokens = value.split(",\\s*");
            int n2 = tokens.length;
            int n3 = 0;
            while (n3 < n2) {
                String token = stringArray[n3];
                result.add(this.unquote(token));
                ++n3;
            }
        }
        return result;
    }

    public void setLastModified(long lastModified) {
        this.setDate(LAST_MODIFIED, lastModified);
    }

    public long getLastModified() {
        return this.getFirstDate(LAST_MODIFIED);
    }

    public void setLocation(URI location) {
        this.set(LOCATION, location.toASCIIString());
    }

    public URI getLocation() {
        String value = this.getFirst(LOCATION);
        return value != null ? URI.create(value) : null;
    }

    public void setPragma(String pragma) {
        this.set(PRAGMA, pragma);
    }

    public String getPragma() {
        return this.getFirst(PRAGMA);
    }

    private String quote(String s2) {
        Assert.notNull(s2);
        if (!s2.startsWith("\"")) {
            s2 = "\"" + s2;
        }
        if (!s2.endsWith("\"")) {
            s2 = String.valueOf(s2) + "\"";
        }
        return s2;
    }

    private String unquote(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.startsWith("\"")) {
            s2 = s2.substring(1);
        }
        if (s2.endsWith("\"")) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        return s2;
    }

    private long getFirstDate(String headerName) {
        String headerValue = this.getFirst(headerName);
        if (headerValue == null) {
            return -1L;
        }
        String[] stringArray = DATE_FORMATS;
        int n2 = DATE_FORMATS.length;
        int n3 = 0;
        while (n3 < n2) {
            String dateFormat = stringArray[n3];
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
            simpleDateFormat.setTimeZone(GMT);
            try {
                return simpleDateFormat.parse(headerValue).getTime();
            }
            catch (ParseException parseException) {
                ++n3;
            }
        }
        throw new IllegalArgumentException("Cannot parse date value \"" + headerValue + "\" for \"" + headerName + "\" header");
    }

    private void setDate(String headerName, long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMATS[0], Locale.US);
        dateFormat.setTimeZone(GMT);
        this.set(headerName, dateFormat.format(new Date(date)));
    }

    @Override
    public String getFirst(String headerName) {
        List<String> headerValues = this.headers.get(headerName);
        return headerValues != null ? headerValues.get(0) : null;
    }

    @Override
    public void add(String headerName, String headerValue) {
        List<String> headerValues = this.headers.get(headerName);
        if (headerValues == null) {
            headerValues = new LinkedList<String>();
            this.headers.put(headerName, headerValues);
        }
        headerValues.add(headerValue);
    }

    @Override
    public void set(String headerName, String headerValue) {
        LinkedList<String> headerValues = new LinkedList<String>();
        headerValues.add(headerValue);
        this.headers.put(headerName, headerValues);
    }

    @Override
    public void setAll(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = new LinkedHashMap<String, String>(this.headers.size());
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            singleValueMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    public List<String> get(Object key) {
        return this.headers.get(key);
    }

    @Override
    public List<String> put(String key, List<String> value) {
        return this.headers.put(key, value);
    }

    @Override
    public List<String> remove(Object key) {
        return this.headers.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m2) {
        this.headers.putAll(m2);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.headers.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHeaders)) {
            return false;
        }
        HttpHeaders otherHeaders = (HttpHeaders)other;
        return this.headers.equals(otherHeaders.headers);
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return this.headers.toString();
    }
}

