/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardClassMetadata;
import org.springframework.core.type.StandardMethodMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAnnotationMetadata
extends StandardClassMetadata
implements AnnotationMetadata {
    public StandardAnnotationMetadata(Class introspectedClass) {
        super(introspectedClass);
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Annotation[] anns;
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n2 = anns.length;
        int n3 = 0;
        while (n3 < n2) {
            Annotation ann = annotationArray[n3];
            types.add(ann.annotationType().getName());
            ++n3;
        }
        return types;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n2 = anns.length;
        int n3 = 0;
        while (n3 < n2) {
            Annotation ann = annotationArray[n3];
            if (ann.annotationType().getName().equals(annotationType)) {
                Annotation[] metaAnns;
                LinkedHashSet<String> types = new LinkedHashSet<String>();
                Annotation[] annotationArray2 = metaAnns = ann.annotationType().getAnnotations();
                int n4 = metaAnns.length;
                int n5 = 0;
                while (n5 < n4) {
                    Annotation metaAnn = annotationArray2[n5];
                    types.add(metaAnn.annotationType().getName());
                    Annotation[] annotationArray3 = metaAnn.annotationType().getAnnotations();
                    int n6 = annotationArray3.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Annotation metaMetaAnn = annotationArray3[n7];
                        types.add(metaMetaAnn.annotationType().getName());
                        ++n7;
                    }
                    ++n5;
                }
                return types;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n2 = anns.length;
        int n3 = 0;
        while (n3 < n2) {
            Annotation ann = annotationArray[n3];
            if (ann.annotationType().getName().equals(annotationType)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean hasMetaAnnotation(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n2 = anns.length;
        int n3 = 0;
        while (n3 < n2) {
            Annotation[] metaAnns;
            Annotation ann = annotationArray[n3];
            Annotation[] annotationArray2 = metaAnns = ann.annotationType().getAnnotations();
            int n4 = metaAnns.length;
            int n5 = 0;
            while (n5 < n4) {
                Annotation metaAnn = annotationArray2[n5];
                if (metaAnn.annotationType().getName().equals(annotationType)) {
                    return true;
                }
                Annotation[] annotationArray3 = metaAnn.annotationType().getAnnotations();
                int n6 = annotationArray3.length;
                int n7 = 0;
                while (n7 < n6) {
                    Annotation metaMetaAnn = annotationArray3[n7];
                    if (metaMetaAnn.annotationType().getName().equals(annotationType)) {
                        return true;
                    }
                    ++n7;
                }
                ++n5;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n2 = anns.length;
        int n3 = 0;
        while (n3 < n2) {
            Annotation ann = annotationArray[n3];
            if (ann.annotationType().getName().equals(annotationType)) {
                return true;
            }
            Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
            int n4 = annotationArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                Annotation metaAnn = annotationArray2[n5];
                if (metaAnn.annotationType().getName().equals(annotationType)) {
                    return true;
                }
                ++n5;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.getAnnotationAttributes(annotationType, false);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n2 = anns.length;
        int n3 = 0;
        while (n3 < n2) {
            Annotation ann = annotationArray[n3];
            if (ann.annotationType().getName().equals(annotationType)) {
                return AnnotationUtils.getAnnotationAttributes(ann, classValuesAsString);
            }
            Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
            int n4 = annotationArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                Annotation metaAnn = annotationArray2[n5];
                if (metaAnn.annotationType().getName().equals(annotationType)) {
                    return AnnotationUtils.getAnnotationAttributes(metaAnn, classValuesAsString);
                }
                ++n5;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationType) {
        Method[] methods;
        Method[] methodArray = methods = this.getIntrospectedClass().getDeclaredMethods();
        int n2 = methods.length;
        int n3 = 0;
        while (n3 < n2) {
            Method method = methodArray[n3];
            Annotation[] annotationArray = method.getAnnotations();
            int n4 = annotationArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Annotation ann = annotationArray[n5];
                if (ann.annotationType().getName().equals(annotationType)) {
                    return true;
                }
                Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
                int n6 = annotationArray2.length;
                int n7 = 0;
                while (n7 < n6) {
                    Annotation metaAnn = annotationArray2[n7];
                    if (metaAnn.annotationType().getName().equals(annotationType)) {
                        return true;
                    }
                    ++n7;
                }
                ++n5;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationType) {
        Method[] methods = this.getIntrospectedClass().getDeclaredMethods();
        LinkedHashSet<MethodMetadata> annotatedMethods = new LinkedHashSet<MethodMetadata>();
        Method[] methodArray = methods;
        int n2 = methods.length;
        int n3 = 0;
        while (n3 < n2) {
            Method method = methodArray[n3];
            Annotation[] annotationArray = method.getAnnotations();
            int n4 = annotationArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Annotation ann = annotationArray[n5];
                if (ann.annotationType().getName().equals(annotationType)) {
                    annotatedMethods.add(new StandardMethodMetadata(method));
                    break;
                }
                Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
                int n6 = annotationArray2.length;
                int n7 = 0;
                while (n7 < n6) {
                    Annotation metaAnn = annotationArray2[n7];
                    if (metaAnn.annotationType().getName().equals(annotationType)) {
                        annotatedMethods.add(new StandardMethodMetadata(method));
                        break;
                    }
                    ++n7;
                }
                ++n5;
            }
            ++n3;
        }
        return annotatedMethods;
    }
}

