/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class CustomCollectionEditor
extends PropertyEditorSupport {
    private final Class collectionType;
    private final boolean nullAsEmptyCollection;

    public CustomCollectionEditor(Class collectionType) {
        this(collectionType, false);
    }

    public CustomCollectionEditor(Class collectionType, boolean nullAsEmptyCollection) {
        if (collectionType == null) {
            throw new IllegalArgumentException("Collection type is required");
        }
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Collection type [" + collectionType.getName() + "] does not implement [java.util.Collection]");
        }
        this.collectionType = collectionType;
        this.nullAsEmptyCollection = nullAsEmptyCollection;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (value == null && this.nullAsEmptyCollection) {
            super.setValue(this.createCollection(this.collectionType, 0));
        } else if (value == null || this.collectionType.isInstance(value) && !this.alwaysCreateNewCollection()) {
            super.setValue(value);
        } else if (value instanceof Collection) {
            Collection source = (Collection)value;
            Collection target = this.createCollection(this.collectionType, source.size());
            for (Object elem : source) {
                target.add(this.convertElement(elem));
            }
            super.setValue(target);
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            Collection target = this.createCollection(this.collectionType, length);
            int i2 = 0;
            while (i2 < length) {
                target.add(this.convertElement(Array.get(value, i2)));
                ++i2;
            }
            super.setValue(target);
        } else {
            Collection target = this.createCollection(this.collectionType, 1);
            target.add(this.convertElement(value));
            super.setValue(target);
        }
    }

    protected Collection createCollection(Class collectionType, int initialCapacity) {
        if (!collectionType.isInterface()) {
            try {
                return (Collection)collectionType.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Could not instantiate collection class [" + collectionType.getName() + "]: " + ex.getMessage());
            }
        }
        if (List.class.equals((Object)collectionType)) {
            return new ArrayList(initialCapacity);
        }
        if (SortedSet.class.equals((Object)collectionType)) {
            return new TreeSet();
        }
        return new LinkedHashSet(initialCapacity);
    }

    protected boolean alwaysCreateNewCollection() {
        return false;
    }

    protected Object convertElement(Object element) {
        return element;
    }

    public String getAsText() {
        return null;
    }
}

