/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ClassArrayEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public ClassArrayEditor() {
        this(null);
    }

    public ClassArrayEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText(text)) {
            String[] classNames = StringUtils.commaDelimitedListToStringArray(text);
            Class[] classes = new Class[classNames.length];
            int i2 = 0;
            while (i2 < classNames.length) {
                String className = classNames[i2].trim();
                classes[i2] = ClassUtils.resolveClassName(className, this.classLoader);
                ++i2;
            }
            this.setValue(classes);
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        Object[] classes = (Class[])this.getValue();
        if (ObjectUtils.isEmpty(classes)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < classes.length) {
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(ClassUtils.getQualifiedName(classes[i2]));
            ++i2;
        }
        return sb.toString();
    }
}

