/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RectangularShape;
import org.jfree.ui.GradientPaintTransformer;

public class DirectionalGradientPaintTransformer
implements GradientPaintTransformer {
    @Override
    public GradientPaint transform(GradientPaint paint, Shape target) {
        float ry2;
        float rx2;
        float ry1;
        float rx1;
        double px1 = paint.getPoint1().getX();
        double py1 = paint.getPoint1().getY();
        double px2 = paint.getPoint2().getX();
        double py2 = paint.getPoint2().getY();
        Rectangle bounds = target.getBounds();
        float bx = (float)((RectangularShape)bounds).getX();
        float by = (float)((RectangularShape)bounds).getY();
        float bw = (float)((RectangularShape)bounds).getWidth();
        float bh = (float)((RectangularShape)bounds).getHeight();
        if (px1 == 0.0 && py1 == 0.0) {
            rx1 = bx;
            ry1 = by;
            if (px2 != 0.0 && py2 != 0.0) {
                float offset = paint.isCyclic() ? (bw + bh) / 4.0f : (bw + bh) / 2.0f;
                rx2 = bx + offset;
                ry2 = by + offset;
            } else {
                float f2 = px2 == 0.0 ? rx1 : (rx2 = paint.isCyclic() ? rx1 + bw / 2.0f : rx1 + bw);
                ry2 = py2 == 0.0 ? ry1 : (paint.isCyclic() ? ry1 + bh / 2.0f : ry1 + bh);
            }
        } else {
            rx1 = bx;
            ry1 = by + bh;
            float offset = paint.isCyclic() ? (bw + bh) / 4.0f : (bw + bh) / 2.0f;
            rx2 = bx + offset;
            ry2 = by + bh - offset;
        }
        return new GradientPaint(rx1, ry1, paint.getColor1(), rx2, ry2, paint.getColor2(), paint.isCyclic());
    }
}

