/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.taglib;

import java.util.Map;
import javax.servlet.jsp.JspException;
import org.homelinux.elabor.springtools.taglib.Option;
import org.homelinux.elabor.ui.render.Renderer;
import org.springframework.web.servlet.tags.form.TagWriter;

public class RendererHelper {
    public static void writeInputGroup(TagWriter writer, String type, String label, String name, String value, String valueClass, boolean disabled) throws JspException {
        writer.startTag("div");
        writer.writeAttribute("class", "form-group");
        writer.startTag("label");
        writer.appendValue(label);
        writer.endTag();
        writer.startTag("input");
        writer.writeAttribute("type", type);
        writer.writeAttribute("id", name);
        writer.writeAttribute("name", name);
        if (valueClass != null) {
            writer.writeAttribute("class", valueClass);
        }
        writer.writeAttribute("value", value);
        if (disabled) {
            writer.writeAttribute("disabled", "disabled");
        }
        writer.endTag();
        writer.endTag();
    }

    public static void writeInput(TagWriter writer, String type, String name, String value, String valueClass, boolean disabled) throws JspException {
        writer.startTag("input");
        writer.writeAttribute("type", type);
        writer.writeAttribute("id", name);
        writer.writeAttribute("name", name);
        if (valueClass != null) {
            writer.writeAttribute("class", valueClass);
        }
        writer.writeAttribute("value", value);
        if (disabled) {
            writer.writeAttribute("disabled", "disabled");
        }
        writer.endTag();
    }

    public static <T extends Option> void writeSelectGroup(TagWriter writer, String label, String name, T[] options, Renderer<T> renderer, String value, boolean disabled) throws JspException {
        writer.startTag("div");
        writer.writeAttribute("class", "form-group");
        writer.startTag("label");
        writer.appendValue(label);
        writer.endTag();
        writer.startTag("select");
        writer.writeAttribute("id", name);
        writer.writeAttribute("name", name);
        writer.writeAttribute("class", "selectpicker");
        if (disabled) {
            writer.writeAttribute("disabled", "disabled");
        }
        T[] TArray = options;
        int n2 = options.length;
        int n3 = 0;
        while (n3 < n2) {
            T option = TArray[n3];
            String optionValue = option.getValue();
            writer.startTag("option");
            writer.writeAttribute("value", optionValue);
            if (optionValue.equals(value)) {
                writer.writeAttribute("selected", "selected");
            }
            writer.appendValue(renderer.getMessage(option));
            writer.endTag();
            ++n3;
        }
        writer.endTag();
        writer.endTag();
    }

    public static void writeLinkGroup(TagWriter writer, String label, String valueClass, Map<String, String> invoicesMap) throws JspException {
        writer.startTag("div");
        writer.writeAttribute("class", "form-group");
        writer.startTag("label");
        writer.appendValue(label);
        writer.endTag();
        for (String invoice : invoicesMap.keySet()) {
            String url = invoicesMap.get(invoice);
            RendererHelper.writeLink(writer, invoice, valueClass, url);
        }
        writer.endTag();
    }

    public static void writeLink(TagWriter writer, String label, String valueClass, String url) throws JspException {
        writer.startTag("a");
        writer.writeAttribute("title", label);
        writer.writeAttribute("class", valueClass);
        writer.writeAttribute("href", url);
        writer.appendValue("");
        writer.endTag();
    }

    public static void writeLinkId(TagWriter writer, String label, String valueClass, String id, String url) throws JspException {
        writer.startTag("a");
        writer.writeAttribute("title", label);
        writer.writeAttribute("class", valueClass);
        writer.writeAttribute("id", id);
        writer.writeAttribute("href", url);
        writer.appendValue("");
        writer.endTag();
    }

    public static void writeLinkName(TagWriter writer, String label, String valueClass, String name, String url) throws JspException {
        writer.startTag("a");
        writer.writeAttribute("title", label);
        writer.writeAttribute("class", valueClass);
        writer.writeAttribute("id", name);
        writer.writeAttribute("name", name);
        writer.writeAttribute("href", url);
        writer.appendValue("");
        writer.endTag();
    }

    public static void writeCheckBox(TagWriter writer, String type, String label, String name, boolean checked) throws JspException {
        RendererHelper.writeCheckBox(writer, type, label, name, checked, true);
    }

    public static void writeCheckBoxNodiv(TagWriter writer, String type, String label, String name, boolean checked, boolean enabled) throws JspException {
        writer.writeAttribute("class", "form-group");
        writer.startTag("label");
        writer.appendValue(label);
        writer.endTag();
        RendererHelper.writeCheckBox(writer, type, name, checked, enabled);
    }

    public static void writeCheckBox(TagWriter writer, String type, String label, String name, boolean checked, boolean enabled) throws JspException {
        writer.startTag("div");
        writer.writeAttribute("class", "form-group");
        writer.startTag("label");
        writer.appendValue(label);
        writer.endTag();
        RendererHelper.writeCheckBox(writer, type, name, checked, enabled);
        writer.endTag();
    }

    public static void writeCheckBox(TagWriter writer, String type, String name, boolean checked, boolean enabled) throws JspException {
        writer.startTag("input");
        writer.writeAttribute("type", type);
        writer.writeAttribute("id", name);
        writer.writeAttribute("name", name);
        if (checked) {
            writer.writeAttribute("checked", "checked");
        }
        if (!enabled) {
            writer.writeAttribute("disabled", "disabled");
        }
        writer.endTag();
        if (checked && !enabled) {
            writer.startTag("input");
            writer.writeAttribute("type", "hidden");
            writer.writeAttribute("id", name);
            writer.writeAttribute("name", name);
            writer.writeAttribute("value", "1");
            writer.endTag();
        }
    }
}

