/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.domain.attachment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.springtools.domain.attachment.Attachment;
import org.homelinux.elabor.springtools.domain.attachment.Picture;

public class AttachmentsContainerImpl {
    private static Integer ANOYMOUS_PICTURE_ID = new Integer(1);
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Integer getIconId() {
        Iterator<Picture> iterator = this.getPictures().iterator();
        if (iterator.hasNext()) {
            Picture picture = iterator.next();
            return picture.getAttachment().getId();
        }
        return ANOYMOUS_PICTURE_ID;
    }

    public List<Picture> getPictures() {
        ArrayList<Picture> pictures = new ArrayList<Picture>();
        for (Attachment attachment : this.getAttachments()) {
            if (!Picture.isPicture(attachment)) continue;
            Picture picture = Picture.getPicture(attachment);
            pictures.add(picture);
        }
        return pictures;
    }

    public void sortAttachments(Integer[] order) {
        ArrayList<Attachment> newAttachments = new ArrayList<Attachment>();
        int i2 = 0;
        while (i2 < order.length) {
            newAttachments.add(this.attachments.get(order[i2]));
            ++i2;
        }
        this.attachments = newAttachments;
    }

    public List<Attachment> getDocuments() {
        ArrayList<Attachment> documents = new ArrayList<Attachment>();
        for (Attachment attachment : this.getAttachments()) {
            if (attachment.getId().equals(this.getIconId())) continue;
            documents.add(attachment);
        }
        return documents;
    }
}

