/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.homelinux.elabor.dom.DomHelper;
import org.homelinux.elabor.pdf.ParagraphBorderEvent;
import org.homelinux.elabor.pdf.ParagraphHandler;
import org.homelinux.elabor.pdf.TypedField;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PdfCreator {
    private PdfCreator() {
    }

    public static void processTemplate(URL templateUrl, File file, Map<String, ? extends TypedField> fieldsMap, Map<String, Object> valuesMap) throws ParserConfigurationException, IOException, SAXException, DocumentException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream stream = new FileOutputStream(file);){
            Document document = new Document();
            PdfWriter writer = PdfWriter.getInstance(document, stream);
            ParagraphBorderEvent border = new ParagraphBorderEvent();
            border.setActive(true);
            writer.setPageEvent(border);
            document.open();
            document.setPageSize(PageSize.A4);
            document.setMargins(40.0f, 40.0f, 40.0f, 40.0f);
            ParagraphHandler paragraphHandler = new ParagraphHandler(document, fieldsMap, valuesMap);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Throwable throwable2 = null;
            Object var14_17 = null;
            try (InputStream inputStream = templateUrl.openStream();){
                org.w3c.dom.Document domDocument = builder.parse(inputStream);
                Element docElement = domDocument.getDocumentElement();
                Iterator<Element> iterator = DomHelper.getElementIterator(docElement, "paragraph");
                while (iterator.hasNext()) {
                    Element paragraph = iterator.next();
                    paragraphHandler.handleParagraph(paragraph, border);
                }
                document.close();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

