/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db.generic;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.db.RecordCreator;
import org.homelinux.elabor.db.generic.FieldManager;
import org.homelinux.elabor.db.generic.Setter;

public class GenericRecordCreator<R>
implements RecordCreator<R> {
    private static final Class<Setter> SETTER_CLASS = Setter.class;
    private Class<R> recordClass;
    private List<FieldManager<R>> managers;

    public GenericRecordCreator(Object dao, Class<R> recordClass) throws NoSuchMethodException {
        this.recordClass = recordClass;
        Method[] methods = recordClass.getMethods();
        this.managers = new ArrayList<FieldManager<R>>();
        Method[] methodArray = methods;
        int n2 = methods.length;
        int n3 = 0;
        while (n3 < n2) {
            Method method = methodArray[n3];
            Setter setter = method.getAnnotation(SETTER_CLASS);
            if (setter != null) {
                String name = setter.field();
                String getterName = setter.getter();
                FieldManager manager = new FieldManager(method, dao, name, getterName);
                this.managers.add(manager);
            }
            ++n3;
        }
    }

    @Override
    public R createRecord(ResultSet rs) {
        R record;
        try {
            record = this.recordClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (FieldManager<R> manager : this.managers) {
                manager.fillField(record, rs);
            }
        }
        catch (Exception e2) {
            throw new DataAccessException(e2);
        }
        return record;
    }
}

