/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Set;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class IntersectionTypeBinding18
extends ReferenceBinding {
    public ReferenceBinding[] intersectingTypes;
    private ReferenceBinding javaLangObject;
    int length;

    public IntersectionTypeBinding18(ReferenceBinding[] intersectingTypes, LookupEnvironment environment) {
        this.intersectingTypes = intersectingTypes;
        this.length = intersectingTypes.length;
        if (!intersectingTypes[0].isClass()) {
            this.javaLangObject = environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
            this.modifiers |= 0x200;
        }
    }

    private IntersectionTypeBinding18(IntersectionTypeBinding18 prototype) {
        this.intersectingTypes = prototype.intersectingTypes;
        this.length = prototype.length;
        if (!this.intersectingTypes[0].isClass()) {
            this.javaLangObject = prototype.javaLangObject;
            this.modifiers |= 0x200;
        }
    }

    @Override
    public TypeBinding clone(TypeBinding enclosingType) {
        return new IntersectionTypeBinding18(this);
    }

    @Override
    protected MethodBinding[] getInterfaceAbstractContracts(Scope scope, boolean replaceWildcards) throws InvalidInputException {
        int typesLength = this.intersectingTypes.length;
        MethodBinding[][] methods = new MethodBinding[typesLength][];
        int contractsLength = 0;
        int i2 = 0;
        while (i2 < typesLength) {
            methods[i2] = this.intersectingTypes[i2].getInterfaceAbstractContracts(scope, replaceWildcards);
            contractsLength += methods[i2].length;
            ++i2;
        }
        MethodBinding[] contracts = new MethodBinding[contractsLength];
        int idx = 0;
        int i3 = 0;
        while (i3 < typesLength) {
            int len = methods[i3].length;
            System.arraycopy(methods[i3], 0, contracts, idx, len);
            idx += len;
            ++i3;
        }
        return contracts;
    }

    @Override
    public boolean hasTypeBit(int bit) {
        int i2 = 0;
        while (i2 < this.length) {
            if (this.intersectingTypes[i2].hasTypeBit(bit)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    @Override
    public boolean canBeSeenBy(PackageBinding invocationPackage) {
        int i2 = 0;
        while (i2 < this.length) {
            if (!this.intersectingTypes[i2].canBeSeenBy(invocationPackage)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public boolean canBeSeenBy(Scope scope) {
        int i2 = 0;
        while (i2 < this.length) {
            if (!this.intersectingTypes[i2].canBeSeenBy(scope)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public boolean canBeSeenBy(ReferenceBinding receiverType, ReferenceBinding invocationType) {
        int i2 = 0;
        while (i2 < this.length) {
            if (!this.intersectingTypes[i2].canBeSeenBy(receiverType, invocationType)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public char[] constantPoolName() {
        return this.intersectingTypes[0].constantPoolName();
    }

    @Override
    public PackageBinding getPackage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceBinding[] getIntersectingTypes() {
        return this.intersectingTypes;
    }

    @Override
    public ReferenceBinding superclass() {
        return this.intersectingTypes[0].isClass() ? this.intersectingTypes[0] : this.javaLangObject;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.intersectingTypes[0].isClass()) {
            ReferenceBinding[] superInterfaces = new ReferenceBinding[this.length - 1];
            System.arraycopy(this.intersectingTypes, 1, superInterfaces, 0, this.length - 1);
            return superInterfaces;
        }
        return this.intersectingTypes;
    }

    @Override
    public boolean isBoxedPrimitiveType() {
        return this.intersectingTypes[0].isBoxedPrimitiveType();
    }

    @Override
    public boolean isCompatibleWith(TypeBinding right, Scope scope) {
        if (TypeBinding.equalsEquals(this, right)) {
            return true;
        }
        int rightKind = right.kind();
        ReferenceBinding[] rightIntersectingTypes = null;
        if (rightKind == 8196 && right.boundKind() == 1) {
            TypeBinding allRightBounds = ((WildcardBinding)right).allBounds();
            if (allRightBounds instanceof IntersectionTypeBinding18) {
                rightIntersectingTypes = ((IntersectionTypeBinding18)allRightBounds).intersectingTypes;
            }
        } else if (rightKind == 32772) {
            rightIntersectingTypes = ((IntersectionTypeBinding18)right).intersectingTypes;
        }
        if (rightIntersectingTypes != null) {
            int numRequired = rightIntersectingTypes.length;
            TypeBinding[] required = new TypeBinding[numRequired];
            System.arraycopy(rightIntersectingTypes, 0, required, 0, numRequired);
            int i2 = 0;
            while (i2 < this.length) {
                ReferenceBinding provided = this.intersectingTypes[i2];
                int j2 = 0;
                while (j2 < required.length) {
                    if (required[j2] != null && ((TypeBinding)provided).isCompatibleWith(required[j2], scope)) {
                        required[j2] = null;
                        if (--numRequired != 0) break;
                        return true;
                    }
                    ++j2;
                }
                ++i2;
            }
            return false;
        }
        int i3 = 0;
        while (i3 < this.length) {
            if (this.intersectingTypes[i3].isCompatibleWith(right, scope)) {
                return true;
            }
            ++i3;
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding other) {
        if (TypeBinding.equalsEquals(this, other)) {
            return true;
        }
        int i2 = 0;
        while (i2 < this.intersectingTypes.length) {
            if (this.intersectingTypes[i2].isSubtypeOf(other)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public char[] qualifiedSourceName() {
        StringBuffer qualifiedSourceName = new StringBuffer(16);
        int i2 = 0;
        while (i2 < this.length) {
            qualifiedSourceName.append(this.intersectingTypes[i2].qualifiedSourceName());
            if (i2 != this.length - 1) {
                qualifiedSourceName.append(" & ");
            }
            ++i2;
        }
        return qualifiedSourceName.toString().toCharArray();
    }

    @Override
    public char[] sourceName() {
        StringBuffer srcName = new StringBuffer(16);
        int i2 = 0;
        while (i2 < this.length) {
            srcName.append(this.intersectingTypes[i2].sourceName());
            if (i2 != this.length - 1) {
                srcName.append(" & ");
            }
            ++i2;
        }
        return srcName.toString().toCharArray();
    }

    @Override
    public char[] readableName() {
        StringBuffer readableName = new StringBuffer(16);
        int i2 = 0;
        while (i2 < this.length) {
            readableName.append(this.intersectingTypes[i2].readableName());
            if (i2 != this.length - 1) {
                readableName.append(" & ");
            }
            ++i2;
        }
        return readableName.toString().toCharArray();
    }

    @Override
    public char[] shortReadableName() {
        StringBuffer shortReadableName = new StringBuffer(16);
        int i2 = 0;
        while (i2 < this.length) {
            shortReadableName.append(this.intersectingTypes[i2].shortReadableName());
            if (i2 != this.length - 1) {
                shortReadableName.append(" & ");
            }
            ++i2;
        }
        return shortReadableName.toString().toCharArray();
    }

    @Override
    public boolean isIntersectionType18() {
        return true;
    }

    @Override
    public int kind() {
        return 32772;
    }

    @Override
    public String debugName() {
        StringBuffer debugName = new StringBuffer(16);
        int i2 = 0;
        while (i2 < this.length) {
            debugName.append(this.intersectingTypes[i2].debugName());
            if (i2 != this.length - 1) {
                debugName.append(" & ");
            }
            ++i2;
        }
        return debugName.toString();
    }

    public String toString() {
        return this.debugName();
    }

    public TypeBinding getSAMType(Scope scope) {
        int i2 = 0;
        int max = this.intersectingTypes.length;
        while (i2 < max) {
            ReferenceBinding typeBinding = this.intersectingTypes[i2];
            MethodBinding methodBinding = ((TypeBinding)typeBinding).getSingleAbstractMethod(scope, true);
            if (methodBinding != null && methodBinding.problemId() != 17) {
                return typeBinding;
            }
            ++i2;
        }
        return null;
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> variables) {
        int i2 = 0;
        while (i2 < this.intersectingTypes.length) {
            this.intersectingTypes[i2].collectInferenceVariables(variables);
            ++i2;
        }
    }

    @Override
    public boolean mentionsAny(TypeBinding[] parameters, int idx) {
        if (super.mentionsAny(parameters, idx)) {
            return true;
        }
        int i2 = 0;
        while (i2 < this.intersectingTypes.length) {
            if (this.intersectingTypes[i2].mentionsAny(parameters, -1)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public long updateTagBits() {
        ReferenceBinding[] referenceBindingArray = this.intersectingTypes;
        int n2 = this.intersectingTypes.length;
        int n3 = 0;
        while (n3 < n2) {
            ReferenceBinding intersectingType = referenceBindingArray[n3];
            this.tagBits |= intersectingType.updateTagBits();
            ++n3;
        }
        return super.updateTagBits();
    }
}

