/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfoWithAnnotations;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;

class MethodInfoWithParameterAnnotations
extends MethodInfoWithAnnotations {
    private AnnotationInfo[][] parameterAnnotations;

    MethodInfoWithParameterAnnotations(MethodInfo methodInfo, AnnotationInfo[] annotations, AnnotationInfo[][] parameterAnnotations) {
        super(methodInfo, annotations);
        this.parameterAnnotations = parameterAnnotations;
    }

    @Override
    public IBinaryAnnotation[] getParameterAnnotations(int index, char[] classFileName) {
        try {
            return this.parameterAnnotations == null ? null : this.parameterAnnotations[index];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            StringBuffer message = new StringBuffer("Mismatching number of parameter annotations, ");
            message.append(index);
            message.append('>');
            message.append(this.parameterAnnotations.length - 1);
            message.append(" in ");
            message.append(this.getSelector());
            char[] desc = this.getGenericSignature();
            if (desc != null) {
                message.append(desc);
            } else {
                message.append(this.getMethodDescriptor());
            }
            if (classFileName != null) {
                message.append(" in ").append(classFileName);
            }
            throw new IllegalStateException(message.toString(), aioobe);
        }
    }

    @Override
    public int getAnnotatedParametersCount() {
        return this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
    }

    @Override
    protected void initialize() {
        int i2 = 0;
        int l2 = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
        while (i2 < l2) {
            AnnotationInfo[] infos = this.parameterAnnotations[i2];
            int j2 = 0;
            int k2 = infos == null ? 0 : infos.length;
            while (j2 < k2) {
                infos[j2].initialize();
                ++j2;
            }
            ++i2;
        }
        super.initialize();
    }

    @Override
    protected void reset() {
        int i2 = 0;
        int l2 = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
        while (i2 < l2) {
            AnnotationInfo[] infos = this.parameterAnnotations[i2];
            int j2 = 0;
            int k2 = infos == null ? 0 : infos.length;
            while (j2 < k2) {
                infos[j2].reset();
                ++j2;
            }
            ++i2;
        }
        super.reset();
    }

    @Override
    protected void toStringContent(StringBuffer buffer) {
        super.toStringContent(buffer);
        int i2 = 0;
        int l2 = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
        while (i2 < l2) {
            buffer.append("param" + (i2 - 1));
            buffer.append('\n');
            AnnotationInfo[] infos = this.parameterAnnotations[i2];
            int j2 = 0;
            int k2 = infos == null ? 0 : infos.length;
            while (j2 < k2) {
                buffer.append(infos[j2]);
                buffer.append('\n');
                ++j2;
            }
            ++i2;
        }
    }
}

