/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.classfile.annotation.NameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.SimpleElementValue;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.GeneratedReferenceTypeDelegate;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAnnotation;
import org.aspectj.weaver.bcel.BcelPerClauseAspectAdder;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerSingleton;

public class ConcreteAspectCodeGen {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Type[] EMPTY_TYPES = new Type[0];
    private final Definition.ConcreteAspect concreteAspect;
    private final World world;
    private boolean isValid = false;
    private ResolvedType parent;
    private PerClause perclause;

    ConcreteAspectCodeGen(Definition.ConcreteAspect concreteAspect, World world) {
        this.concreteAspect = concreteAspect;
        this.world = world;
    }

    public boolean validate() {
        String perclauseString;
        if (!(this.world instanceof BcelWorld)) {
            this.reportError("Internal error: world must be of type BcelWorld");
            return false;
        }
        ReferenceType current = this.world.lookupBySignature(UnresolvedType.forName(this.concreteAspect.name).getSignature());
        if (current != null && !current.isMissing()) {
            this.reportError("Attempt to concretize but chosen aspect name already defined: " + this.stringify());
            return false;
        }
        if (this.concreteAspect.extend == null && this.concreteAspect.precedence != null) {
            if (this.concreteAspect.pointcuts.isEmpty()) {
                this.isValid = true;
                this.parent = null;
                return true;
            }
            this.reportError("Attempt to use nested pointcuts without extends clause: " + this.stringify());
            return false;
        }
        String parentAspectName = this.concreteAspect.extend;
        if (parentAspectName.indexOf("<") != -1) {
            this.parent = this.world.resolve(UnresolvedType.forName(parentAspectName), true);
            if (this.parent.isMissing()) {
                this.reportError("Unable to resolve type reference: " + this.stringify());
                return false;
            }
            if (this.parent.isParameterizedType()) {
                UnresolvedType[] typeParameters = this.parent.getTypeParameters();
                for (int i2 = 0; i2 < typeParameters.length; ++i2) {
                    UnresolvedType typeParameter = typeParameters[i2];
                    if (!(typeParameter instanceof ResolvedType) || !((ResolvedType)typeParameter).isMissing()) continue;
                    this.reportError("Unablet to resolve type parameter '" + typeParameter.getName() + "' from " + this.stringify());
                    return false;
                }
            }
        } else {
            this.parent = this.world.resolve(this.concreteAspect.extend, true);
        }
        if (this.parent.isMissing()) {
            String fixedName = this.concreteAspect.extend;
            int hasDot = fixedName.lastIndexOf(46);
            while (hasDot > 0) {
                char[] fixedNameChars = fixedName.toCharArray();
                fixedNameChars[hasDot] = 36;
                fixedName = new String(fixedNameChars);
                hasDot = fixedName.lastIndexOf(46);
                this.parent = this.world.resolve(UnresolvedType.forName(fixedName), true);
                if (this.parent.isMissing()) continue;
                break;
            }
        }
        if (this.parent.isMissing()) {
            this.reportError("Cannot find m_parent aspect for: " + this.stringify());
            return false;
        }
        if (!this.parent.isAbstract()) {
            this.reportError("Attempt to concretize a non-abstract aspect: " + this.stringify());
            return false;
        }
        if (!this.parent.isAspect()) {
            this.reportError("Attempt to concretize a non aspect: " + this.stringify());
            return false;
        }
        ArrayList<String> elligibleAbstractions = new ArrayList<String>();
        Collection abstractMethods = this.getOutstandingAbstractMethods(this.parent);
        for (ResolvedMember method : abstractMethods) {
            if ("()V".equals(method.getSignature())) {
                String n2 = method.getName();
                if (n2.startsWith("ajc$pointcut")) {
                    n2 = n2.substring(14);
                    n2 = n2.substring(0, n2.indexOf("$"));
                    elligibleAbstractions.add(n2);
                    continue;
                }
                if (this.hasPointcutAnnotation(method)) {
                    elligibleAbstractions.add(method.getName());
                    continue;
                }
                this.reportError("Abstract method '" + method.toString() + "' cannot be concretized in XML: " + this.stringify());
                return false;
            }
            if (method.getName().startsWith("ajc$pointcut") || this.hasPointcutAnnotation(method)) {
                this.reportError("Abstract method '" + method.toString() + "' cannot be concretized as a pointcut (illegal signature, must have no arguments, must return void): " + this.stringify());
                return false;
            }
            this.reportError("Abstract method '" + method.toString() + "' cannot be concretized in XML: " + this.stringify());
            return false;
        }
        ArrayList<String> pointcutNames = new ArrayList<String>();
        for (Definition.Pointcut abstractPc : this.concreteAspect.pointcuts) {
            pointcutNames.add(abstractPc.name);
        }
        for (String elligiblePc : elligibleAbstractions) {
            if (pointcutNames.contains(elligiblePc)) continue;
            this.reportError("Abstract pointcut '" + elligiblePc + "' not configured: " + this.stringify());
            return false;
        }
        if (!(this.concreteAspect.perclause == null || (perclauseString = this.concreteAspect.perclause).startsWith("persingleton") || perclauseString.startsWith("percflow") || perclauseString.startsWith("pertypewithin") || perclauseString.startsWith("perthis") || perclauseString.startsWith("pertarget") || perclauseString.startsWith("percflowbelow"))) {
            this.reportError("Unrecognized per clause specified " + this.stringify());
            return false;
        }
        this.isValid = true;
        return this.isValid;
    }

    private Collection getOutstandingAbstractMethods(ResolvedType type) {
        HashMap collector = new HashMap();
        this.getOutstandingAbstractMethodsHelper(type, collector);
        return collector.values();
    }

    private void getOutstandingAbstractMethodsHelper(ResolvedType type, Map collector) {
        ResolvedMember[] rms;
        if (type == null) {
            return;
        }
        if (!type.equals(ResolvedType.OBJECT) && type.getSuperclass() != null) {
            this.getOutstandingAbstractMethodsHelper(type.getSuperclass(), collector);
        }
        if ((rms = type.getDeclaredMethods()) != null) {
            for (int i2 = 0; i2 < rms.length; ++i2) {
                ResolvedMember member = rms[i2];
                String key = member.getName() + member.getSignature();
                if (member.isAbstract()) {
                    collector.put(key, member);
                    continue;
                }
                collector.remove(key);
            }
        }
    }

    private String stringify() {
        StringBuffer sb = new StringBuffer("<concrete-aspect name='");
        sb.append(this.concreteAspect.name);
        sb.append("' extends='");
        sb.append(this.concreteAspect.extend);
        sb.append("' perclause='");
        sb.append(this.concreteAspect.perclause);
        sb.append("'/> in aop.xml");
        return sb.toString();
    }

    private boolean hasPointcutAnnotation(ResolvedMember member) {
        AnnotationAJ[] as = member.getAnnotations();
        if (as == null || as.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < as.length; ++i2) {
            if (!as[i2].getTypeSignature().equals("Lorg/aspectj/lang/annotation/Pointcut;")) continue;
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this.concreteAspect.name;
    }

    public byte[] getBytes() {
        PerClause parentPerClause;
        if (!this.isValid) {
            throw new RuntimeException("Must validate first");
        }
        PerClause perClause = parentPerClause = this.parent != null ? this.parent.getPerClause() : null;
        if (parentPerClause == null) {
            parentPerClause = new PerSingleton();
        }
        PerClause.Kind perclauseKind = PerClause.SINGLETON;
        String perclauseString = null;
        if (this.concreteAspect.perclause != null) {
            perclauseString = this.concreteAspect.perclause;
            if (perclauseString.startsWith("persingleton")) {
                perclauseKind = PerClause.SINGLETON;
            } else if (perclauseString.startsWith("percflow")) {
                perclauseKind = PerClause.PERCFLOW;
            } else if (perclauseString.startsWith("pertypewithin")) {
                perclauseKind = PerClause.PERTYPEWITHIN;
            } else if (perclauseString.startsWith("perthis")) {
                perclauseKind = PerClause.PEROBJECT;
            } else if (perclauseString.startsWith("pertarget")) {
                perclauseKind = PerClause.PEROBJECT;
            } else if (perclauseString.startsWith("percflowbelow")) {
                perclauseKind = PerClause.PERCFLOW;
            }
        }
        String parentName = "java/lang/Object";
        if (this.parent != null) {
            parentName = this.parent.isParameterizedType() ? this.parent.getGenericType().getName().replace('.', '/') : this.parent.getName().replace('.', '/');
        }
        LazyClassGen cg = new LazyClassGen(this.concreteAspect.name.replace('.', '/'), parentName, null, 33, EMPTY_STRINGS, this.world);
        if (this.parent != null && this.parent.isParameterizedType()) {
            cg.setSuperClass(this.parent);
        }
        if (perclauseString == null) {
            AnnotationGen ag = new AnnotationGen(new ObjectType("org/aspectj/lang/annotation/Aspect"), Collections.EMPTY_LIST, true, cg.getConstantPool());
            cg.addAnnotation(ag);
        } else {
            ArrayList<NameValuePair> elems = new ArrayList<NameValuePair>();
            elems.add(new NameValuePair("value", (ElementValue)new SimpleElementValue(115, cg.getConstantPool(), perclauseString), cg.getConstantPool()));
            AnnotationGen ag = new AnnotationGen(new ObjectType("org/aspectj/lang/annotation/Aspect"), elems, true, cg.getConstantPool());
            cg.addAnnotation(ag);
        }
        if (this.concreteAspect.precedence != null) {
            SimpleElementValue svg = new SimpleElementValue(115, cg.getConstantPool(), this.concreteAspect.precedence);
            ArrayList<NameValuePair> elems = new ArrayList<NameValuePair>();
            elems.add(new NameValuePair("value", (ElementValue)svg, cg.getConstantPool()));
            AnnotationGen agprec = new AnnotationGen(new ObjectType("org/aspectj/lang/annotation/DeclarePrecedence"), elems, true, cg.getConstantPool());
            cg.addAnnotation(agprec);
        }
        LazyMethodGen init = new LazyMethodGen(1, Type.VOID, "<init>", EMPTY_TYPES, EMPTY_STRINGS, cg);
        InstructionList cbody = init.getBody();
        cbody.append(InstructionConstants.ALOAD_0);
        cbody.append(cg.getFactory().createInvoke(parentName, "<init>", Type.VOID, EMPTY_TYPES, (short)183));
        cbody.append(InstructionConstants.RETURN);
        cg.addMethodGen(init);
        for (Definition.Pointcut abstractPc : this.concreteAspect.pointcuts) {
            LazyMethodGen mg = new LazyMethodGen(1, Type.VOID, abstractPc.name, EMPTY_TYPES, EMPTY_STRINGS, cg);
            SimpleElementValue svg = new SimpleElementValue(115, cg.getConstantPool(), abstractPc.expression);
            ArrayList<NameValuePair> elems = new ArrayList<NameValuePair>();
            elems.add(new NameValuePair("value", (ElementValue)svg, cg.getConstantPool()));
            AnnotationGen mag = new AnnotationGen(new ObjectType("org/aspectj/lang/annotation/Pointcut"), elems, true, cg.getConstantPool());
            BcelAnnotation max = new BcelAnnotation(mag, this.world);
            mg.addAnnotation(max);
            InstructionList body = mg.getBody();
            body.append(InstructionConstants.RETURN);
            cg.addMethodGen(mg);
        }
        ReferenceType rt = new ReferenceType(ResolvedType.forName(this.concreteAspect.name).getSignature(), this.world);
        GeneratedReferenceTypeDelegate grtd = new GeneratedReferenceTypeDelegate(rt);
        grtd.setSuperclass(this.parent);
        rt.setDelegate(grtd);
        BcelPerClauseAspectAdder perClauseMunger = new BcelPerClauseAspectAdder(rt, perclauseKind);
        perClauseMunger.forceMunge(cg, false);
        JavaClass jc = cg.getJavaClass((BcelWorld)this.world);
        ((BcelWorld)this.world).addSourceObjectType(jc, true);
        return jc.getBytes();
    }

    private void reportError(String message) {
        this.world.getMessageHandler().handleMessage(new Message(message, IMessage.ERROR, null, null));
    }
}

