/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.JoinPointSignature;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberImpl;
import org.aspectj.weaver.MemberKind;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeFactory;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableDeclaringElement;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.TypeVariableReferenceType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.UnresolvedTypeVariableReferenceType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedMemberImpl
extends MemberImpl
implements IHasPosition,
AnnotatedElement,
TypeVariableDeclaringElement,
ResolvedMember {
    private String[] parameterNames = null;
    protected UnresolvedType[] checkedExceptions = UnresolvedType.NONE;
    protected ResolvedMember backingGenericMember = null;
    protected Set<ResolvedType> annotationTypes = null;
    protected ResolvedType[][] parameterAnnotationTypes = null;
    private boolean isAnnotatedElsewhere = false;
    private boolean isAjSynthetic = false;
    protected TypeVariable[] typeVariables;
    protected int start;
    protected int end;
    protected ISourceContext sourceContext = null;
    private String myParameterSignatureWithBoundsRemoved = null;
    private String myParameterSignatureErasure = null;
    public static boolean showParameterNames = true;

    public ResolvedMemberImpl(MemberKind kind, UnresolvedType declaringType, int modifiers, UnresolvedType returnType2, String name, UnresolvedType[] parameterTypes) {
        super(kind, declaringType, modifiers, returnType2, name, parameterTypes);
    }

    public ResolvedMemberImpl(MemberKind kind, UnresolvedType declaringType, int modifiers, UnresolvedType returnType2, String name, UnresolvedType[] parameterTypes, UnresolvedType[] checkedExceptions) {
        super(kind, declaringType, modifiers, returnType2, name, parameterTypes);
        this.checkedExceptions = checkedExceptions;
    }

    public ResolvedMemberImpl(MemberKind kind, UnresolvedType declaringType, int modifiers, UnresolvedType returnType2, String name, UnresolvedType[] parameterTypes, UnresolvedType[] checkedExceptions, ResolvedMember backingGenericMember) {
        this(kind, declaringType, modifiers, returnType2, name, parameterTypes, checkedExceptions);
        this.backingGenericMember = backingGenericMember;
        this.isAjSynthetic = backingGenericMember.isAjSynthetic();
    }

    public ResolvedMemberImpl(MemberKind kind, UnresolvedType declaringType, int modifiers, String name, String signature) {
        super(kind, declaringType, modifiers, name, signature);
    }

    public static JoinPointSignature[] getJoinPointSignatures(Member joinPointSignature, World inAWorld) {
        ResolvedType originalDeclaringType = joinPointSignature.getDeclaringType().resolve(inAWorld);
        ResolvedMemberImpl firstDefiningMember = (ResolvedMemberImpl)joinPointSignature.resolve(inAWorld);
        if (firstDefiningMember == null) {
            return new JoinPointSignature[0];
        }
        ResolvedType firstDefiningType = firstDefiningMember.getDeclaringType().resolve(inAWorld);
        if (firstDefiningType != originalDeclaringType && joinPointSignature.getKind() == Member.CONSTRUCTOR) {
            return new JoinPointSignature[0];
        }
        ArrayList<ResolvedType> declaringTypes = new ArrayList<ResolvedType>();
        ResolvedMemberImpl.accumulateTypesInBetween(originalDeclaringType, firstDefiningType, declaringTypes);
        HashSet<ResolvedMember> memberSignatures = new HashSet<ResolvedMember>();
        for (ResolvedType declaringType : declaringTypes) {
            memberSignatures.add(new JoinPointSignature(firstDefiningMember, declaringType));
        }
        if (ResolvedMemberImpl.shouldWalkUpHierarchyFor(firstDefiningMember)) {
            Iterator<ResolvedType> superTypeIterator = firstDefiningType.getDirectSupertypes();
            ArrayList<ResolvedType> typesAlreadyVisited = new ArrayList<ResolvedType>();
            ResolvedMemberImpl.accumulateMembersMatching(firstDefiningMember, superTypeIterator, typesAlreadyVisited, memberSignatures, false);
        }
        JoinPointSignature[] ret = new JoinPointSignature[memberSignatures.size()];
        memberSignatures.toArray(ret);
        return ret;
    }

    private static boolean shouldWalkUpHierarchyFor(Member aMember) {
        if (aMember.getKind() == Member.CONSTRUCTOR) {
            return false;
        }
        if (aMember.getKind() == Member.FIELD) {
            return false;
        }
        return !Modifier.isStatic(aMember.getModifiers());
    }

    private static void accumulateTypesInBetween(ResolvedType subType, ResolvedType superType, List<ResolvedType> types) {
        types.add(subType);
        if (subType == superType) {
            return;
        }
        Iterator<ResolvedType> iter = subType.getDirectSupertypes();
        while (iter.hasNext()) {
            ResolvedType parent = iter.next();
            if (!superType.isAssignableFrom(parent)) continue;
            ResolvedMemberImpl.accumulateTypesInBetween(parent, superType, types);
        }
    }

    private static void accumulateMembersMatching(ResolvedMemberImpl memberToMatch, Iterator<ResolvedType> typesToLookIn, List<ResolvedType> typesAlreadyVisited, Set<ResolvedMember> foundMembers, boolean ignoreGenerics) {
        while (typesToLookIn.hasNext()) {
            ResolvedType toLookIn = typesToLookIn.next();
            if (typesAlreadyVisited.contains(toLookIn)) continue;
            typesAlreadyVisited.add(toLookIn);
            ResolvedMemberImpl foundMember = (ResolvedMemberImpl)toLookIn.lookupResolvedMember(memberToMatch, true, ignoreGenerics);
            if (foundMember == null || !ResolvedMemberImpl.isVisibleTo(memberToMatch, foundMember)) continue;
            ArrayList<ResolvedType> declaringTypes = new ArrayList<ResolvedType>();
            ResolvedType resolvedDeclaringType = foundMember.getDeclaringType().resolve(toLookIn.getWorld());
            ResolvedMemberImpl.accumulateTypesInBetween(toLookIn, resolvedDeclaringType, declaringTypes);
            for (ResolvedType declaringType : declaringTypes) {
                foundMembers.add(new JoinPointSignature(foundMember, declaringType));
            }
            if (!ignoreGenerics && toLookIn.isParameterizedType() && foundMember.backingGenericMember != null) {
                foundMembers.add(new JoinPointSignature(foundMember.backingGenericMember, foundMember.declaringType.resolve(toLookIn.getWorld())));
            }
            ResolvedMemberImpl.accumulateMembersMatching(foundMember, toLookIn.getDirectSupertypes(), typesAlreadyVisited, foundMembers, ignoreGenerics);
        }
    }

    private static boolean isVisibleTo(ResolvedMember childMember, ResolvedMember parentMember) {
        if (childMember.getDeclaringType().equals(parentMember.getDeclaringType())) {
            return true;
        }
        return !Modifier.isPrivate(parentMember.getModifiers());
    }

    @Override
    public final int getModifiers(World world) {
        return this.modifiers;
    }

    @Override
    public final int getModifiers() {
        return this.modifiers;
    }

    @Override
    public final UnresolvedType[] getExceptions(World world) {
        return this.getExceptions();
    }

    @Override
    public UnresolvedType[] getExceptions() {
        return this.checkedExceptions;
    }

    @Override
    public ShadowMunger getAssociatedShadowMunger() {
        return null;
    }

    @Override
    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }

    protected void setAjSynthetic(boolean b2) {
        this.isAjSynthetic = b2;
    }

    @Override
    public boolean hasAnnotations() {
        return this.annotationTypes != null;
    }

    @Override
    public boolean hasAnnotation(UnresolvedType ofType) {
        if (this.backingGenericMember != null) {
            if (this.annotationTypes != null) {
                throw new BCException("Unexpectedly found a backing generic member and a local set of annotations");
            }
            return this.backingGenericMember.hasAnnotation(ofType);
        }
        if (this.annotationTypes == null) {
            return false;
        }
        return this.annotationTypes.contains(ofType);
    }

    @Override
    public ResolvedType[] getAnnotationTypes() {
        if (this.backingGenericMember != null) {
            if (this.annotationTypes != null) {
                throw new BCException("Unexpectedly found a backing generic member and a local set of annotations");
            }
            return this.backingGenericMember.getAnnotationTypes();
        }
        if (this.annotationTypes == null) {
            return null;
        }
        return this.annotationTypes.toArray(new ResolvedType[0]);
    }

    @Override
    public String getAnnotationDefaultValue() {
        throw new UnsupportedOperationException("You should resolve this member and call getAnnotationDefaultValue() on the result...");
    }

    @Override
    public AnnotationAJ[] getAnnotations() {
        if (this.backingGenericMember != null) {
            return this.backingGenericMember.getAnnotations();
        }
        return super.getAnnotations();
    }

    @Override
    public void setAnnotationTypes(ResolvedType[] annotationtypes) {
        if (this.annotationTypes == null) {
            this.annotationTypes = new HashSet<ResolvedType>();
        }
        for (int i2 = 0; i2 < annotationtypes.length; ++i2) {
            ResolvedType typeX = annotationtypes[i2];
            this.annotationTypes.add(typeX);
        }
    }

    @Override
    public ResolvedType[][] getParameterAnnotationTypes() {
        if (this.parameterAnnotationTypes == null) {
            return null;
        }
        return this.parameterAnnotationTypes;
    }

    @Override
    public AnnotationAJ[][] getParameterAnnotations() {
        if (this.backingGenericMember != null) {
            return this.backingGenericMember.getParameterAnnotations();
        }
        throw new BCException("Cannot return parameter annotations for a " + this.getClass().getName() + " member");
    }

    @Override
    public void addAnnotation(AnnotationAJ annotation) {
        if (this.annotationTypes == null) {
            this.annotationTypes = new HashSet<ResolvedType>();
        }
        this.annotationTypes.add(annotation.getType());
    }

    @Override
    public boolean isBridgeMethod() {
        return (this.modifiers & 0x40) != 0 && this.getKind().equals(METHOD);
    }

    @Override
    public boolean isVarargsMethod() {
        return (this.modifiers & 0x80) != 0;
    }

    public void setVarargsMethod() {
        this.modifiers |= 0x80;
    }

    @Override
    public boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    @Override
    public void write(DataOutputStream s2) throws IOException {
        this.getKind().write(s2);
        this.getDeclaringType().write(s2);
        s2.writeInt(this.modifiers);
        s2.writeUTF(this.getName());
        s2.writeUTF(this.getSignature());
        UnresolvedType.writeArray(this.getExceptions(), s2);
        s2.writeInt(this.getStart());
        s2.writeInt(this.getEnd());
        s2.writeBoolean(this.isVarargsMethod());
        if (this.typeVariables == null) {
            s2.writeInt(0);
        } else {
            s2.writeInt(this.typeVariables.length);
            for (int i2 = 0; i2 < this.typeVariables.length; ++i2) {
                this.typeVariables[i2].write(s2);
            }
        }
        String gsig = this.getGenericSignature();
        if (this.getSignature().equals(gsig)) {
            s2.writeBoolean(false);
        } else {
            s2.writeBoolean(true);
            s2.writeInt(this.parameterTypes.length);
            for (int i3 = 0; i3 < this.parameterTypes.length; ++i3) {
                UnresolvedType array_element = this.parameterTypes[i3];
                array_element.write(s2);
            }
            this.returnType.write(s2);
        }
    }

    public String getSignatureForAttribute() {
        int i2;
        StringBuffer sb = new StringBuffer();
        if (this.typeVariables != null) {
            sb.append("<");
            for (i2 = 0; i2 < this.typeVariables.length; ++i2) {
                sb.append(this.typeVariables[i2].getSignatureForAttribute());
            }
            sb.append(">");
        }
        sb.append("(");
        for (i2 = 0; i2 < this.parameterTypes.length; ++i2) {
            ResolvedType ptype = (ResolvedType)this.parameterTypes[i2];
            sb.append(ptype.getSignatureForAttribute());
        }
        sb.append(")");
        sb.append(((ResolvedType)this.returnType).getSignatureForAttribute());
        return sb.toString();
    }

    public String getGenericSignature() {
        int i2;
        StringBuffer sb = new StringBuffer();
        if (this.typeVariables != null) {
            sb.append("<");
            for (i2 = 0; i2 < this.typeVariables.length; ++i2) {
                sb.append(this.typeVariables[i2].getSignature());
            }
            sb.append(">");
        }
        sb.append("(");
        for (i2 = 0; i2 < this.parameterTypes.length; ++i2) {
            UnresolvedType ptype = this.parameterTypes[i2];
            sb.append(ptype.getSignature());
        }
        sb.append(")");
        sb.append(this.returnType.getSignature());
        return sb.toString();
    }

    public static void writeArray(ResolvedMember[] members, DataOutputStream s2) throws IOException {
        s2.writeInt(members.length);
        int len = members.length;
        for (int i2 = 0; i2 < len; ++i2) {
            members[i2].write(s2);
        }
    }

    public static ResolvedMemberImpl readResolvedMember(VersionedDataInputStream s2, ISourceContext sourceContext) throws IOException {
        ResolvedMemberImpl m2 = new ResolvedMemberImpl(MemberKind.read(s2), UnresolvedType.read(s2), s2.readInt(), s2.readUTF(), s2.readUTF());
        m2.checkedExceptions = UnresolvedType.readArray(s2);
        m2.start = s2.readInt();
        m2.end = s2.readInt();
        m2.sourceContext = sourceContext;
        if (s2.getMajorVersion() >= 2) {
            boolean hasAGenericSignature;
            int tvcount;
            boolean isvarargs;
            if (s2.getMajorVersion() >= 3 && (isvarargs = s2.readBoolean())) {
                m2.setVarargsMethod();
            }
            if ((tvcount = s2.readInt()) != 0) {
                m2.typeVariables = new TypeVariable[tvcount];
                for (int i2 = 0; i2 < tvcount; ++i2) {
                    m2.typeVariables[i2] = TypeVariable.read(s2);
                    m2.typeVariables[i2].setDeclaringElement(m2);
                }
            }
            if (s2.getMajorVersion() >= 3 && (hasAGenericSignature = s2.readBoolean())) {
                int ps = s2.readInt();
                UnresolvedType[] params = new UnresolvedType[ps];
                for (int i3 = 0; i3 < params.length; ++i3) {
                    params[i3] = TypeFactory.createTypeFromSignature(s2.readUTF());
                }
                UnresolvedType rt = TypeFactory.createTypeFromSignature(s2.readUTF());
                m2.parameterTypes = params;
                m2.returnType = rt;
            }
        }
        return m2;
    }

    public static ResolvedMember[] readResolvedMemberArray(VersionedDataInputStream s2, ISourceContext context) throws IOException {
        int len = s2.readInt();
        ResolvedMember[] members = new ResolvedMember[len];
        for (int i2 = 0; i2 < len; ++i2) {
            members[i2] = ResolvedMemberImpl.readResolvedMember(s2, context);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedMember resolve(World world) {
        try {
            int i2;
            if (this.typeVariables != null && this.typeVariables.length > 0) {
                for (i2 = 0; i2 < this.typeVariables.length; ++i2) {
                    this.typeVariables[i2] = this.typeVariables[i2].resolve(world);
                }
            }
            world.setTypeVariableLookupScope(this);
            this.declaringType = this.declaringType.resolve(world);
            if (this.declaringType.isRawType()) {
                this.declaringType = ((ReferenceType)this.declaringType).getGenericType();
            }
            if (this.parameterTypes != null && this.parameterTypes.length > 0) {
                for (i2 = 0; i2 < this.parameterTypes.length; ++i2) {
                    this.parameterTypes[i2] = this.parameterTypes[i2].resolve(world);
                }
            }
            this.returnType = this.returnType.resolve(world);
        }
        finally {
            world.setTypeVariableLookupScope(null);
        }
        return this;
    }

    @Override
    public ISourceContext getSourceContext(World world) {
        return this.getDeclaringType().resolve(world).getSourceContext();
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterNames;
    }

    @Override
    public final void setParameterNames(String[] pnames) {
        this.parameterNames = pnames;
    }

    @Override
    public final String[] getParameterNames(World world) {
        return this.getParameterNames();
    }

    @Override
    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        return null;
    }

    @Override
    public ISourceLocation getSourceLocation() {
        if (this.getSourceContext() == null) {
            return null;
        }
        return this.getSourceContext().makeSourceLocation(this);
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public ISourceContext getSourceContext() {
        return this.sourceContext;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setPosition(int sourceStart, int sourceEnd) {
        this.start = sourceStart;
        this.end = sourceEnd;
    }

    public void setDeclaringType(ReferenceType rt) {
        this.declaringType = rt;
    }

    @Override
    public void setSourceContext(ISourceContext sourceContext) {
        this.sourceContext = sourceContext;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    @Override
    public boolean isDefault() {
        int mods = this.getModifiers();
        return !Modifier.isPublic(mods) && !Modifier.isProtected(mods) && !Modifier.isPrivate(mods);
    }

    @Override
    public boolean isVisible(ResolvedType fromType) {
        World world = fromType.getWorld();
        return ResolvedType.isVisible(this.getModifiers(), this.getDeclaringType().resolve(world), fromType);
    }

    @Override
    public void setCheckedExceptions(UnresolvedType[] checkedExceptions) {
        this.checkedExceptions = checkedExceptions;
    }

    @Override
    public void setAnnotatedElsewhere(boolean b2) {
        this.isAnnotatedElsewhere = b2;
    }

    @Override
    public boolean isAnnotatedElsewhere() {
        return this.isAnnotatedElsewhere;
    }

    @Override
    public UnresolvedType getGenericReturnType() {
        return this.getReturnType();
    }

    @Override
    public UnresolvedType[] getGenericParameterTypes() {
        return this.getParameterTypes();
    }

    @Override
    public ResolvedMemberImpl parameterizedWith(UnresolvedType[] typeParameters, ResolvedType newDeclaringType, boolean isParameterized) {
        return this.parameterizedWith(typeParameters, newDeclaringType, isParameterized, null);
    }

    @Override
    public ResolvedMemberImpl parameterizedWith(UnresolvedType[] typeParameters, ResolvedType newDeclaringType, boolean isParameterized, List aliases) {
        boolean typeParametersSupplied;
        if (!this.getDeclaringType().isGenericType()) {
            throw new IllegalStateException("Can't ask to parameterize a member of non-generic type: " + this.getDeclaringType() + "  kind(" + this.getDeclaringType().typeKind + ")");
        }
        TypeVariable[] typeVariables = this.getDeclaringType().getTypeVariables();
        if (isParameterized && typeVariables.length != typeParameters.length) {
            throw new IllegalStateException("Wrong number of type parameters supplied");
        }
        HashMap<String, UnresolvedType> typeMap = new HashMap<String, UnresolvedType>();
        boolean bl = typeParametersSupplied = typeParameters != null && typeParameters.length > 0;
        if (typeVariables != null) {
            for (int i2 = 0; i2 < typeVariables.length; ++i2) {
                UnresolvedType ut = !typeParametersSupplied ? typeVariables[i2].getFirstBound() : typeParameters[i2];
                typeMap.put(typeVariables[i2].getName(), ut);
            }
        }
        if (aliases != null) {
            int posn = 0;
            for (String typeVariableAlias : aliases) {
                typeMap.put(typeVariableAlias, !typeParametersSupplied ? typeVariables[posn].getFirstBound() : typeParameters[posn]);
                ++posn;
            }
        }
        UnresolvedType parameterizedReturnType = this.parameterize(this.getGenericReturnType(), typeMap, isParameterized, newDeclaringType.getWorld());
        UnresolvedType[] parameterizedParameterTypes = new UnresolvedType[this.getGenericParameterTypes().length];
        UnresolvedType[] genericParameterTypes = this.getGenericParameterTypes();
        for (int i3 = 0; i3 < parameterizedParameterTypes.length; ++i3) {
            parameterizedParameterTypes[i3] = this.parameterize(genericParameterTypes[i3], typeMap, isParameterized, newDeclaringType.getWorld());
        }
        ResolvedMemberImpl ret = new ResolvedMemberImpl(this.getKind(), newDeclaringType, this.getModifiers(), parameterizedReturnType, this.getName(), parameterizedParameterTypes, this.getExceptions(), this);
        ret.setTypeVariables(this.getTypeVariables());
        ret.setSourceContext(this.getSourceContext());
        ret.setPosition(this.getStart(), this.getEnd());
        ret.setParameterNames(this.getParameterNames());
        return ret;
    }

    @Override
    public ResolvedMember parameterizedWith(Map m2, World w) {
        this.declaringType = this.declaringType.resolve(w);
        if (this.declaringType.isRawType()) {
            this.declaringType = ((ResolvedType)this.declaringType).getGenericType();
        }
        UnresolvedType parameterizedReturnType = this.parameterize(this.getGenericReturnType(), m2, true, w);
        UnresolvedType[] parameterizedParameterTypes = new UnresolvedType[this.getGenericParameterTypes().length];
        UnresolvedType[] genericParameterTypes = this.getGenericParameterTypes();
        for (int i2 = 0; i2 < parameterizedParameterTypes.length; ++i2) {
            parameterizedParameterTypes[i2] = this.parameterize(genericParameterTypes[i2], m2, true, w);
        }
        ResolvedMemberImpl ret = new ResolvedMemberImpl(this.getKind(), this.declaringType, this.getModifiers(), parameterizedReturnType, this.getName(), parameterizedParameterTypes, this.getExceptions(), this);
        ret.setTypeVariables(this.getTypeVariables());
        ret.setSourceContext(this.getSourceContext());
        ret.setPosition(this.getStart(), this.getEnd());
        ret.setParameterNames(this.getParameterNames());
        return ret;
    }

    @Override
    public void setTypeVariables(TypeVariable[] tvars) {
        this.typeVariables = tvars;
    }

    @Override
    public TypeVariable[] getTypeVariables() {
        return this.typeVariables;
    }

    protected UnresolvedType parameterize(UnresolvedType aType, Map typeVariableMap, boolean inParameterizedType, World w) {
        if (aType instanceof TypeVariableReference) {
            String variableName = ((TypeVariableReference)((Object)aType)).getTypeVariable().getName();
            if (!typeVariableMap.containsKey(variableName)) {
                return aType;
            }
            return (UnresolvedType)typeVariableMap.get(variableName);
        }
        if (aType.isParameterizedType()) {
            if (inParameterizedType) {
                if (w != null) {
                    aType = aType.resolve(w);
                } else {
                    UnresolvedType dType = this.getDeclaringType();
                    aType = aType.resolve(((ResolvedType)dType).getWorld());
                }
                return aType.parameterize(typeVariableMap);
            }
            return aType.getRawType();
        }
        if (aType.isArray()) {
            int dims = 1;
            String sig = aType.getSignature();
            UnresolvedType arrayType = null;
            UnresolvedType componentSig = UnresolvedType.forSignature(sig.substring(dims));
            UnresolvedType parameterizedComponentSig = this.parameterize(componentSig, typeVariableMap, inParameterizedType, w);
            if (parameterizedComponentSig.isTypeVariableReference() && parameterizedComponentSig instanceof UnresolvedTypeVariableReferenceType && typeVariableMap.containsKey(((UnresolvedTypeVariableReferenceType)parameterizedComponentSig).getTypeVariable().getName())) {
                StringBuffer newsig = new StringBuffer();
                newsig.append("[T");
                newsig.append(((UnresolvedTypeVariableReferenceType)parameterizedComponentSig).getTypeVariable().getName());
                newsig.append(";");
                arrayType = UnresolvedType.forSignature(newsig.toString());
            } else {
                arrayType = ResolvedType.makeArray(parameterizedComponentSig, dims);
            }
            return arrayType;
        }
        return aType;
    }

    @Override
    public boolean hasBackingGenericMember() {
        return this.backingGenericMember != null;
    }

    @Override
    public ResolvedMember getBackingGenericMember() {
        return this.backingGenericMember;
    }

    public void resetName(String newName) {
        this.name = newName;
    }

    public void resetKind(MemberKind newKind) {
        this.kind = newKind;
    }

    public void resetModifiers(int newModifiers) {
        this.modifiers = newModifiers;
    }

    public void resetReturnTypeToObjectArray() {
        this.returnType = UnresolvedType.OBJECTARRAY;
    }

    @Override
    public boolean matches(ResolvedMember aCandidateMatch, boolean ignoreGenerics) {
        String candidateParameterSignature;
        UnresolvedType[] candidateParameterTypes;
        ResolvedMemberImpl candidateMatchImpl = (ResolvedMemberImpl)aCandidateMatch;
        if (!this.getName().equals(aCandidateMatch.getName())) {
            return false;
        }
        UnresolvedType[] parameterTypes = this.getGenericParameterTypes();
        if (parameterTypes.length != (candidateParameterTypes = aCandidateMatch.getGenericParameterTypes()).length) {
            return false;
        }
        boolean b2 = false;
        String myParameterSignature = this.getParameterSigWithBoundsRemoved();
        if (myParameterSignature.equals(candidateParameterSignature = candidateMatchImpl.getParameterSigWithBoundsRemoved())) {
            b2 = true;
        } else {
            myParameterSignature = this.getParameterSignatureErased();
            candidateParameterSignature = candidateMatchImpl.getParameterSignatureErased();
            b2 = myParameterSignature.equals(candidateParameterSignature);
        }
        return b2;
    }

    private String getParameterSigWithBoundsRemoved() {
        if (this.myParameterSignatureWithBoundsRemoved != null) {
            return this.myParameterSignatureWithBoundsRemoved;
        }
        StringBuffer sig = new StringBuffer();
        UnresolvedType[] myParameterTypes = this.getGenericParameterTypes();
        for (int i2 = 0; i2 < myParameterTypes.length; ++i2) {
            ResolvedMemberImpl.appendSigWithTypeVarBoundsRemoved(myParameterTypes[i2], sig, new HashSet());
        }
        this.myParameterSignatureWithBoundsRemoved = sig.toString();
        return this.myParameterSignatureWithBoundsRemoved;
    }

    @Override
    public String getParameterSignatureErased() {
        if (this.myParameterSignatureErasure != null) {
            return this.myParameterSignatureErasure;
        }
        StringBuffer sig = new StringBuffer();
        UnresolvedType[] myParameterTypes = this.getParameterTypes();
        for (int i2 = 0; i2 < myParameterTypes.length; ++i2) {
            UnresolvedType thisParameter = myParameterTypes[i2];
            sig.append(thisParameter.getErasureSignature());
        }
        this.myParameterSignatureErasure = sig.toString();
        return this.myParameterSignatureErasure;
    }

    @Override
    public String getSignatureErased() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(this.getParameterSignatureErased());
        sb.append(")");
        sb.append(this.getReturnType().getErasureSignature());
        return sb.toString();
    }

    public static void appendSigWithTypeVarBoundsRemoved(UnresolvedType aType, StringBuffer toBuffer, Set alreadyUsedTypeVars) {
        if (aType.isTypeVariableReference()) {
            TypeVariableReferenceType typeVariableRT = (TypeVariableReferenceType)aType;
            if (alreadyUsedTypeVars.contains(aType)) {
                toBuffer.append("...");
            } else {
                alreadyUsedTypeVars.add(aType);
                ResolvedMemberImpl.appendSigWithTypeVarBoundsRemoved(typeVariableRT.getUpperBound(), toBuffer, alreadyUsedTypeVars);
            }
        } else if (aType.isParameterizedType()) {
            toBuffer.append(aType.getRawType().getSignature());
            toBuffer.append("<");
            for (int i2 = 0; i2 < aType.getTypeParameters().length; ++i2) {
                ResolvedMemberImpl.appendSigWithTypeVarBoundsRemoved(aType.getTypeParameters()[i2], toBuffer, alreadyUsedTypeVars);
            }
            toBuffer.append(">;");
        } else {
            toBuffer.append(aType.getSignature());
        }
    }

    @Override
    public String toDebugString() {
        String modsStr;
        StringBuffer r2 = new StringBuffer();
        int mods = this.modifiers;
        if ((mods & 0x1000) > 0) {
            mods -= 4096;
        }
        if ((mods & 0x200) > 0) {
            mods -= 512;
        }
        if ((mods & 0x20000) > 0) {
            mods -= 131072;
        }
        if ((modsStr = Modifier.toString(mods)).length() != 0) {
            r2.append(modsStr).append("(" + mods + ")").append(" ");
        }
        if (this.typeVariables != null && this.typeVariables.length > 0) {
            r2.append("<");
            for (int i2 = 0; i2 < this.typeVariables.length; ++i2) {
                if (i2 > 0) {
                    r2.append(",");
                }
                TypeVariable t = this.typeVariables[i2];
                r2.append(t.toDebugString());
            }
            r2.append("> ");
        }
        r2.append(this.getGenericReturnType().toDebugString());
        r2.append(' ');
        r2.append(this.declaringType.getName());
        r2.append('.');
        r2.append(this.name);
        if (this.kind != FIELD) {
            boolean parameterNamesExist;
            r2.append("(");
            UnresolvedType[] params = this.getGenericParameterTypes();
            boolean bl = parameterNamesExist = showParameterNames && this.parameterNames != null && this.parameterNames.length == params.length;
            if (params.length != 0) {
                int len = params.length;
                for (int i3 = 0; i3 < len; ++i3) {
                    if (i3 > 0) {
                        r2.append(", ");
                    }
                    r2.append(params[i3].toDebugString());
                    if (!parameterNamesExist) continue;
                    r2.append(" ").append(this.parameterNames[i3]);
                }
            }
            r2.append(")");
        }
        return r2.toString();
    }

    @Override
    public String toGenericString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getGenericReturnType().getSimpleName());
        buf.append(' ');
        buf.append(this.declaringType.getName());
        buf.append('.');
        buf.append(this.name);
        if (this.kind != FIELD) {
            buf.append("(");
            UnresolvedType[] params = this.getGenericParameterTypes();
            if (params.length != 0) {
                buf.append(params[0].getSimpleName());
                int len = params.length;
                for (int i2 = 1; i2 < len; ++i2) {
                    buf.append(", ");
                    buf.append(params[i2].getSimpleName());
                }
            }
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public boolean isCompatibleWith(Member am) {
        if (this.kind != METHOD || am.getKind() != METHOD) {
            return true;
        }
        if (!this.name.equals(am.getName())) {
            return true;
        }
        if (!ResolvedMemberImpl.equalTypes(this.getParameterTypes(), am.getParameterTypes())) {
            return true;
        }
        return this.getReturnType().equals(am.getReturnType());
    }

    private static boolean equalTypes(UnresolvedType[] a2, UnresolvedType[] b2) {
        int len = a2.length;
        if (len != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (a2[i2].equals(b2[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public TypeVariable getTypeVariableNamed(String name) {
        if (this.typeVariables != null) {
            for (int i2 = 0; i2 < this.typeVariables.length; ++i2) {
                if (!this.typeVariables[i2].getName().equals(name)) continue;
                return this.typeVariables[i2];
            }
        }
        return this.declaringType.getTypeVariableNamed(name);
    }

    @Override
    public void evictWeavingState() {
    }

    @Override
    public AnnotationAJ getAnnotationOfType(UnresolvedType ofType) {
        throw new UnsupportedOperationException("You should resolve this member and call getAnnotationOfType() on the result...");
    }

    public boolean isEquivalentTo(Object other) {
        return this.equals(other);
    }

    @Override
    public boolean isDefaultConstructor() {
        return false;
    }
}

