/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class ArrayReferenceType
extends ReferenceType {
    private final ResolvedType componentType;

    public ArrayReferenceType(String sig, String erasureSig, World world, ResolvedType componentType) {
        super(sig, erasureSig, world);
        this.componentType = componentType;
    }

    public final ResolvedMember[] getDeclaredFields() {
        return ResolvedMember.NONE;
    }

    public final ResolvedMember[] getDeclaredMethods() {
        return ResolvedMember.NONE;
    }

    public final ResolvedType[] getDeclaredInterfaces() {
        return new ResolvedType[]{this.world.getCoreType(CLONEABLE), this.world.getCoreType(SERIALIZABLE)};
    }

    public AnnotationAJ getAnnotationOfType(UnresolvedType ofType) {
        return null;
    }

    public AnnotationAJ[] getAnnotations() {
        return AnnotationAJ.EMPTY_ARRAY;
    }

    public ResolvedType[] getAnnotationTypes() {
        return ResolvedType.NONE;
    }

    public final ResolvedMember[] getDeclaredPointcuts() {
        return ResolvedMember.NONE;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        return false;
    }

    public final ResolvedType getSuperclass() {
        return this.world.getCoreType(OBJECT);
    }

    public final boolean isAssignableFrom(ResolvedType o2) {
        if (!o2.isArray()) {
            return false;
        }
        if (o2.getComponentType().isPrimitiveType()) {
            return o2.equals(this);
        }
        return this.getComponentType().resolve(this.world).isAssignableFrom(o2.getComponentType().resolve(this.world));
    }

    public boolean isAssignableFrom(ResolvedType o2, boolean allowMissing) {
        return this.isAssignableFrom(o2);
    }

    public final boolean isCoerceableFrom(ResolvedType o2) {
        if (o2.equals(UnresolvedType.OBJECT) || o2.equals(UnresolvedType.SERIALIZABLE) || o2.equals(UnresolvedType.CLONEABLE)) {
            return true;
        }
        if (!o2.isArray()) {
            return false;
        }
        if (o2.getComponentType().isPrimitiveType()) {
            return o2.equals(this);
        }
        return this.getComponentType().resolve(this.world).isCoerceableFrom(o2.getComponentType().resolve(this.world));
    }

    public final int getModifiers() {
        int mask = 7;
        return this.componentType.getModifiers() & mask | 0x10;
    }

    public UnresolvedType getComponentType() {
        return this.componentType;
    }

    public ResolvedType getResolvedComponentType() {
        return this.componentType;
    }

    public ISourceContext getSourceContext() {
        return this.getResolvedComponentType().getSourceContext();
    }

    public TypeVariable[] getTypeVariables() {
        if (this.typeVariables == null && this.componentType.getTypeVariables() != null) {
            this.typeVariables = this.componentType.getTypeVariables();
            for (int i2 = 0; i2 < this.typeVariables.length; ++i2) {
                this.typeVariables[i2].resolve(this.world);
            }
        }
        return this.typeVariables;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isAnnotationStyleAspect() {
        return false;
    }

    public boolean isAspect() {
        return false;
    }

    public boolean isPrimitiveType() {
        return this.typeKind == UnresolvedType.TypeKind.PRIMITIVE;
    }

    public boolean isSimpleType() {
        return this.typeKind == UnresolvedType.TypeKind.SIMPLE;
    }

    public boolean isRawType() {
        return this.typeKind == UnresolvedType.TypeKind.RAW;
    }

    public boolean isGenericType() {
        return this.typeKind == UnresolvedType.TypeKind.GENERIC;
    }

    public boolean isParameterizedType() {
        return this.typeKind == UnresolvedType.TypeKind.PARAMETERIZED;
    }

    public boolean isTypeVariableReference() {
        return this.typeKind == UnresolvedType.TypeKind.TYPE_VARIABLE;
    }

    public boolean isGenericWildcard() {
        return this.typeKind == UnresolvedType.TypeKind.WILDCARD;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isNested() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public boolean canAnnotationTargetType() {
        return false;
    }

    public AnnotationTargetKind[] getAnnotationTargetKinds() {
        return null;
    }

    public boolean isAnnotationWithRuntimeRetention() {
        return false;
    }
}

