/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionSelect;
import org.aspectj.apache.bcel.generic.LOOKUPSWITCH;
import org.aspectj.apache.bcel.generic.TABLESWITCH;

public final class SwitchBuilder {
    private int[] match;
    private InstructionHandle[] targets;
    private InstructionSelect instruction;
    private int match_length;

    public SwitchBuilder(int[] match, InstructionHandle[] targets, InstructionHandle target, int max_gap) {
        this.match = (int[])match.clone();
        this.targets = (InstructionHandle[])targets.clone();
        this.match_length = match.length;
        if (this.match_length < 2) {
            this.instruction = match.length == 0 ? new LOOKUPSWITCH(match, targets, target) : new TABLESWITCH(match, targets, target);
        } else {
            this.sort(0, this.match_length - 1);
            if (this.matchIsOrdered(max_gap)) {
                this.fillup(max_gap, target);
                this.instruction = new TABLESWITCH(this.match, this.targets, target);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, target);
            }
        }
    }

    public SwitchBuilder(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        this(match, targets, target, 1);
    }

    private final void fillup(int max_gap, InstructionHandle target) {
        int max_size = this.match_length + this.match_length * max_gap;
        int[] m_vec = new int[max_size];
        InstructionHandle[] t_vec = new InstructionHandle[max_size];
        int count = 1;
        m_vec[0] = this.match[0];
        t_vec[0] = this.targets[0];
        int i2 = 1;
        while (i2 < this.match_length) {
            int prev = this.match[i2 - 1];
            int gap = this.match[i2] - prev;
            int j2 = 1;
            while (j2 < gap) {
                m_vec[count] = prev + j2;
                t_vec[count] = target;
                ++count;
                ++j2;
            }
            m_vec[count] = this.match[i2];
            t_vec[count] = this.targets[i2];
            ++count;
            ++i2;
        }
        this.match = new int[count];
        this.targets = new InstructionHandle[count];
        System.arraycopy(m_vec, 0, this.match, 0, count);
        System.arraycopy(t_vec, 0, this.targets, 0, count);
    }

    private final void sort(int l2, int r2) {
        int i2 = l2;
        int j2 = r2;
        int m2 = this.match[(l2 + r2) / 2];
        while (true) {
            if (this.match[i2] < m2) {
                ++i2;
                continue;
            }
            while (m2 < this.match[j2]) {
                --j2;
            }
            if (i2 <= j2) {
                int h2 = this.match[i2];
                this.match[i2] = this.match[j2];
                this.match[j2] = h2;
                InstructionHandle h22 = this.targets[i2];
                this.targets[i2] = this.targets[j2];
                this.targets[j2] = h22;
                ++i2;
                --j2;
            }
            if (i2 > j2) break;
        }
        if (l2 < j2) {
            this.sort(l2, j2);
        }
        if (i2 < r2) {
            this.sort(i2, r2);
        }
    }

    private final boolean matchIsOrdered(int max_gap) {
        int i2 = 1;
        while (i2 < this.match_length) {
            int diff = this.match[i2] - this.match[i2 - 1];
            if (diff > max_gap || diff < 0) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public final InstructionSelect getInstruction() {
        return this.instruction;
    }
}

