/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import org.apache.tomcat.util.bcel.Const;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.Constant;

public class ConstantPool {
    private final Constant[] constant_pool;

    ConstantPool(DataInput input) throws IOException, ClassFormatException {
        int constant_pool_count = input.readUnsignedShort();
        this.constant_pool = new Constant[constant_pool_count];
        for (int i2 = 1; i2 < constant_pool_count; ++i2) {
            byte tag;
            this.constant_pool[i2] = Constant.readConstant(input);
            if (this.constant_pool[i2] == null || (tag = this.constant_pool[i2].getTag()) != 6 && tag != 5) continue;
            ++i2;
        }
    }

    public Constant getConstant(int index) {
        if (index >= this.constant_pool.length || index < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[index];
    }

    public Constant getConstant(int index, byte tag) throws ClassFormatException {
        Constant c2 = this.getConstant(index);
        if (c2 == null) {
            throw new ClassFormatException("Constant pool at index " + index + " is null.");
        }
        if (c2.getTag() != tag) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(tag) + "' at index " + index + " and got " + c2);
        }
        return c2;
    }
}

