/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.tomcat.dbcp.pool2.impl.InterruptibleReentrantLock;

class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    private transient Node<E> first;
    private transient Node<E> last;
    private transient int count;
    private final int capacity;
    private final InterruptibleReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(boolean fairness) {
        this(Integer.MAX_VALUE, fairness);
    }

    public LinkedBlockingDeque(int capacity) {
        this(capacity, false);
    }

    public LinkedBlockingDeque(int capacity, boolean fairness) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.lock = new InterruptibleReentrantLock(fairness);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedBlockingDeque(Collection<? extends E> c2) {
        this(Integer.MAX_VALUE);
        this.lock.lock();
        try {
            for (E e2 : c2) {
                if (e2 == null) {
                    throw new NullPointerException();
                }
                if (super.linkLast(e2)) continue;
                throw new IllegalStateException("Deque full");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean linkFirst(E e2) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> f2 = this.first;
        Node<E> x = new Node<E>(e2, null, f2);
        this.first = x;
        if (this.last == null) {
            this.last = x;
        } else {
            f2.prev = x;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(E e2) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> l2 = this.last;
        Node<E> x = new Node<E>(e2, l2, null);
        this.last = x;
        if (this.first == null) {
            this.first = x;
        } else {
            l2.next = x;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private E unlinkFirst() {
        Node<E> f2 = this.first;
        if (f2 == null) {
            return null;
        }
        Node n2 = f2.next;
        Object item = f2.item;
        f2.item = null;
        f2.next = f2;
        this.first = n2;
        if (n2 == null) {
            this.last = null;
        } else {
            n2.prev = null;
        }
        --this.count;
        this.notFull.signal();
        return item;
    }

    private E unlinkLast() {
        Node<E> l2 = this.last;
        if (l2 == null) {
            return null;
        }
        Node p2 = l2.prev;
        Object item = l2.item;
        l2.item = null;
        l2.prev = l2;
        this.last = p2;
        if (p2 == null) {
            this.first = null;
        } else {
            p2.next = null;
        }
        --this.count;
        this.notFull.signal();
        return item;
    }

    private void unlink(Node<E> x) {
        Node p2 = x.prev;
        Node n2 = x.next;
        if (p2 == null) {
            this.unlinkFirst();
        } else if (n2 == null) {
            this.unlinkLast();
        } else {
            p2.next = n2;
            n2.prev = p2;
            x.item = null;
            --this.count;
            this.notFull.signal();
        }
    }

    @Override
    public void addFirst(E e2) {
        if (!this.offerFirst(e2)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void addLast(E e2) {
        if (!this.offerLast(e2)) {
            throw new IllegalStateException("Deque full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkFirst(e2);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkLast(e2);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFirst(E e2) throws InterruptedException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkFirst(e2)) {
                this.notFull.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLast(E e2) throws InterruptedException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkLast(e2)) {
                this.notFull.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerFirst(E e2, long timeout, TimeUnit unit) throws InterruptedException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (!this.linkFirst(e2)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerLast(E e2, long timeout, TimeUnit unit) throws InterruptedException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (!this.linkLast(e2)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E removeFirst() {
        E x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E removeLast() {
        E x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst() {
        this.lock.lock();
        try {
            E e2 = this.unlinkFirst();
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast() {
        this.lock.lock();
        try {
            E e2 = this.unlinkLast();
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E takeFirst() throws InterruptedException {
        this.lock.lock();
        try {
            E x;
            while ((x = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            E e2 = x;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E takeLast() throws InterruptedException {
        this.lock.lock();
        try {
            E x;
            while ((x = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            E e2 = x;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            E x;
            while ((x = this.unlinkFirst()) == null) {
                if (nanos <= 0L) {
                    E e2 = null;
                    return e2;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E e3 = x;
            return e3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            E x;
            while ((x = this.unlinkLast()) == null) {
                if (nanos <= 0L) {
                    E e2 = null;
                    return e2;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E e3 = x;
            return e3;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E getFirst() {
        E x = this.peekFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E getLast() {
        E x = this.peekLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekFirst() {
        this.lock.lock();
        try {
            E e2 = this.first == null ? null : (E)this.first.item;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekLast() {
        this.lock.lock();
        try {
            E e2 = this.last == null ? null : (E)this.last.item;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFirstOccurrence(Object o2) {
        if (o2 == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node<E> p2 = this.first;
            while (p2 != null) {
                if (o2.equals(p2.item)) {
                    this.unlink(p2);
                    boolean bl = true;
                    return bl;
                }
                p2 = p2.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object o2) {
        if (o2 == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node<E> p2 = this.last;
            while (p2 != null) {
                if (o2.equals(p2.item)) {
                    this.unlink(p2);
                    boolean bl = true;
                    return bl;
                }
                p2 = p2.prev;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean add(E e2) {
        this.addLast(e2);
        return true;
    }

    @Override
    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    public void put(E e2) throws InterruptedException {
        this.putLast(e2);
    }

    public boolean offer(E e2, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e2, timeout, unit);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollFirst(timeout, unit);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n2 = this.capacity - this.count;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int drainTo(Collection<? super E> c2) {
        return this.drainTo(c2, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> c2, int maxElements) {
        if (c2 == null) {
            throw new NullPointerException();
        }
        if (c2 == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n2 = Math.min(maxElements, this.count);
            for (int i2 = 0; i2 < n2; ++i2) {
                c2.add(this.first.item);
                this.unlinkFirst();
            }
            int n3 = n2;
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object o2) {
        return this.removeFirstOccurrence(o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.lock.lock();
        try {
            int n2 = this.count;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o2) {
        if (o2 == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node<E> p2 = this.first;
            while (p2 != null) {
                if (o2.equals(p2.item)) {
                    boolean bl = true;
                    return bl;
                }
                p2 = p2.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] a2 = new Object[this.count];
            int k2 = 0;
            Node<E> p2 = this.first;
            while (p2 != null) {
                a2[k2++] = p2.item;
                p2 = p2.next;
            }
            Object[] objectArray = a2;
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a2) {
        this.lock.lock();
        try {
            if (a2.length < this.count) {
                a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this.count);
            }
            int k2 = 0;
            Node<E> p2 = this.first;
            while (p2 != null) {
                a2[k2++] = p2.item;
                p2 = p2.next;
            }
            if (a2.length > k2) {
                a2[k2] = null;
            }
            Object[] objectArray = a2;
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            Node<E> f2 = this.first;
            while (f2 != null) {
                f2.item = null;
                Node n2 = f2.next;
                f2.prev = null;
                f2.next = null;
                f2 = n2;
            }
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s2) throws IOException {
        this.lock.lock();
        try {
            s2.defaultWriteObject();
            Node<E> p2 = this.first;
            while (p2 != null) {
                s2.writeObject(p2.item);
                p2 = p2.next;
            }
            s2.writeObject(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        Object item;
        s2.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((item = s2.readObject()) != null) {
            this.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTakeWaiters() {
        this.lock.lock();
        try {
            boolean bl = this.lock.hasWaiters(this.notEmpty);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTakeQueueLength() {
        this.lock.lock();
        try {
            int n2 = this.lock.getWaitQueueLength(this.notEmpty);
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interuptTakeWaiters() {
        this.lock.lock();
        try {
            this.lock.interruptWaiters(this.notEmpty);
        }
        finally {
            this.lock.unlock();
        }
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.last;
        }

        @Override
        Node<E> nextNode(Node<E> n2) {
            return n2.prev;
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.first;
        }

        @Override
        Node<E> nextNode(Node<E> n2) {
            return n2.next;
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        Node<E> next;
        E nextItem;
        private Node<E> lastRet;

        abstract Node<E> firstNode();

        abstract Node<E> nextNode(Node<E> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractItr() {
            LinkedBlockingDeque.this.lock.lock();
            try {
                this.next = this.firstNode();
                this.nextItem = this.next == null ? null : this.next.item;
            }
            finally {
                LinkedBlockingDeque.this.lock.unlock();
            }
        }

        private Node<E> succ(Node<E> n2) {
            Node s2;
            while ((s2 = this.nextNode(n2)) != null) {
                if (s2.item != null) {
                    return s2;
                }
                if (s2 == n2) {
                    return this.firstNode();
                }
                n2 = s2;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void advance() {
            LinkedBlockingDeque.this.lock.lock();
            try {
                this.next = this.succ(this.next);
                this.nextItem = this.next == null ? null : this.next.item;
            }
            finally {
                LinkedBlockingDeque.this.lock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            Object x = this.nextItem;
            this.advance();
            return x;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Node n2 = this.lastRet;
            if (n2 == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            LinkedBlockingDeque.this.lock.lock();
            try {
                if (n2.item != null) {
                    LinkedBlockingDeque.this.unlink(n2);
                }
            }
            finally {
                LinkedBlockingDeque.this.lock.unlock();
            }
        }
    }

    private static final class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(E x, Node<E> p2, Node<E> n2) {
            this.item = x;
            this.prev = p2;
            this.next = n2;
        }
    }
}

