/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.taglibs.standard.tag.common.xml.UnresolvableException;

public class JSTLXPathVariableResolver
implements XPathVariableResolver {
    private PageContext pageContext;
    private static final String PAGE_NS_URL = "http://java.sun.com/jstl/xpath/page";
    private static final String REQUEST_NS_URL = "http://java.sun.com/jstl/xpath/request";
    private static final String SESSION_NS_URL = "http://java.sun.com/jstl/xpath/session";
    private static final String APP_NS_URL = "http://java.sun.com/jstl/xpath/app";
    private static final String PARAM_NS_URL = "http://java.sun.com/jstl/xpath/param";
    private static final String INITPARAM_NS_URL = "http://java.sun.com/jstl/xpath/initParam";
    private static final String COOKIE_NS_URL = "http://java.sun.com/jstl/xpath/cookie";
    private static final String HEADER_NS_URL = "http://java.sun.com/jstl/xpath/header";

    public JSTLXPathVariableResolver(PageContext pc) {
        this.pageContext = pc;
    }

    public Object resolveVariable(QName qname) throws NullPointerException {
        Object varObject = null;
        if (qname == null) {
            throw new NullPointerException("Cannot resolve null variable");
        }
        String namespace = qname.getNamespaceURI();
        String prefix = qname.getPrefix();
        String localName = qname.getLocalPart();
        try {
            varObject = this.getVariableValue(namespace, prefix, localName);
        }
        catch (UnresolvableException ue) {
            System.out.println("JSTLXpathVariableResolver.resolveVariable threw UnresolvableException: " + ue);
        }
        return varObject;
    }

    protected Object getVariableValue(String namespace, String prefix, String localName) throws UnresolvableException {
        if (namespace == null || namespace.equals("")) {
            return this.notNull(this.pageContext.findAttribute(localName), namespace, localName);
        }
        if (namespace.equals(PAGE_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(localName, 1), namespace, localName);
        }
        if (namespace.equals(REQUEST_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(localName, 2), namespace, localName);
        }
        if (namespace.equals(SESSION_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(localName, 3), namespace, localName);
        }
        if (namespace.equals(APP_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(localName, 4), namespace, localName);
        }
        if (namespace.equals(PARAM_NS_URL)) {
            return this.notNull(this.pageContext.getRequest().getParameter(localName), namespace, localName);
        }
        if (namespace.equals(INITPARAM_NS_URL)) {
            return this.notNull(this.pageContext.getServletContext().getInitParameter(localName), namespace, localName);
        }
        if (namespace.equals(HEADER_NS_URL)) {
            HttpServletRequest hsr = (HttpServletRequest)this.pageContext.getRequest();
            return this.notNull(hsr.getHeader(localName), namespace, localName);
        }
        if (namespace.equals(COOKIE_NS_URL)) {
            HttpServletRequest hsr = (HttpServletRequest)this.pageContext.getRequest();
            Cookie[] c2 = hsr.getCookies();
            for (int i2 = 0; i2 < c2.length; ++i2) {
                if (!c2[i2].getName().equals(localName)) continue;
                return c2[i2].getValue();
            }
            throw new UnresolvableException("$" + namespace + ":" + localName);
        }
        throw new UnresolvableException("$" + namespace + ":" + localName);
    }

    private Object notNull(Object o2, String namespace, String localName) throws UnresolvableException {
        if (o2 == null) {
            throw new UnresolvableException("$" + (namespace == null ? "" : namespace + ":") + localName);
        }
        return o2;
    }

    private static void p(String s2) {
        System.out.println("[JSTLXPathVariableResolver] " + s2);
    }
}

