/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.taglibs.standard.resources.Resources;

public class Util {
    private static final String REQUEST = "request";
    private static final String SESSION = "session";
    private static final String APPLICATION = "application";
    private static final String DEFAULT = "default";
    private static final String SHORT = "short";
    private static final String MEDIUM = "medium";
    private static final String LONG = "long";
    private static final String FULL = "full";
    public static final int HIGHEST_SPECIAL = 62;
    public static char[][] specialCharactersRepresentation = new char[63][];

    public static int getScope(String scope) {
        int ret = 1;
        if (REQUEST.equalsIgnoreCase(scope)) {
            ret = 2;
        } else if (SESSION.equalsIgnoreCase(scope)) {
            ret = 3;
        } else if (APPLICATION.equalsIgnoreCase(scope)) {
            ret = 4;
        }
        return ret;
    }

    public static int getStyle(String style, String errCode) throws JspException {
        int ret = 2;
        if (style != null) {
            if (DEFAULT.equalsIgnoreCase(style)) {
                ret = 2;
            } else if (SHORT.equalsIgnoreCase(style)) {
                ret = 3;
            } else if (MEDIUM.equalsIgnoreCase(style)) {
                ret = 2;
            } else if (LONG.equalsIgnoreCase(style)) {
                ret = 1;
            } else if (FULL.equalsIgnoreCase(style)) {
                ret = 0;
            } else {
                throw new JspException(Resources.getMessage(errCode, style));
            }
        }
        return ret;
    }

    public static String escapeXml(String buffer) {
        int start = 0;
        int length = buffer.length();
        char[] arrayBuffer = buffer.toCharArray();
        StringBuffer escapedBuffer = null;
        for (int i2 = 0; i2 < length; ++i2) {
            char[] escaped;
            char c2 = arrayBuffer[i2];
            if (c2 > '>' || (escaped = specialCharactersRepresentation[c2]) == null) continue;
            if (start == 0) {
                escapedBuffer = new StringBuffer(length + 5);
            }
            if (start < i2) {
                escapedBuffer.append(arrayBuffer, start, i2 - start);
            }
            start = i2 + 1;
            escapedBuffer.append(escaped);
        }
        if (start == 0) {
            return buffer;
        }
        if (start < length) {
            escapedBuffer.append(arrayBuffer, start, length - start);
        }
        return escapedBuffer.toString();
    }

    public static String getContentTypeAttribute(String input, String name) {
        int end;
        int begin;
        int index = input.toUpperCase().indexOf(name.toUpperCase());
        if (index == -1) {
            return null;
        }
        index += name.length();
        if ((index = input.indexOf(61, index)) == -1) {
            return null;
        }
        if ((input = input.substring(++index).trim()).charAt(0) == '\"') {
            begin = 1;
            end = input.indexOf(34, begin);
            if (end == -1) {
                return null;
            }
        } else {
            begin = 0;
            end = input.indexOf(59);
            if (end == -1) {
                end = input.indexOf(32);
            }
            if (end == -1) {
                end = input.length();
            }
        }
        return input.substring(begin, end).trim();
    }

    public static String URLEncode(String s2, String enc) {
        if (s2 == null) {
            return "null";
        }
        if (enc == null) {
            enc = "UTF-8";
        }
        StringBuffer out = new StringBuffer(s2.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, enc);
        }
        catch (UnsupportedEncodingException ex) {
            writer = new OutputStreamWriter(buf);
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == ' ') {
                out.append('+');
                continue;
            }
            if (Util.isSafeChar(c2)) {
                out.append(c2);
                continue;
            }
            try {
                writer.write(c2);
                writer.flush();
            }
            catch (IOException e2) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j2 = 0; j2 < ba.length; ++j2) {
                out.append('%');
                out.append(Character.forDigit(ba[j2] >> 4 & 0xF, 16));
                out.append(Character.forDigit(ba[j2] & 0xF, 16));
            }
            buf.reset();
        }
        return out.toString();
    }

    private static boolean isSafeChar(int c2) {
        if (c2 >= 97 && c2 <= 122) {
            return true;
        }
        if (c2 >= 65 && c2 <= 90) {
            return true;
        }
        if (c2 >= 48 && c2 <= 57) {
            return true;
        }
        return c2 == 45 || c2 == 95 || c2 == 46 || c2 == 33 || c2 == 126 || c2 == 42 || c2 == 39 || c2 == 40 || c2 == 41;
    }

    public static Enumeration getRequestLocales(HttpServletRequest request) {
        Enumeration<String> values = request.getHeaders("accept-language");
        if (values.hasMoreElements()) {
            return request.getLocales();
        }
        return values;
    }

    static {
        Util.specialCharactersRepresentation[38] = "&amp;".toCharArray();
        Util.specialCharactersRepresentation[60] = "&lt;".toCharArray();
        Util.specialCharactersRepresentation[62] = "&gt;".toCharArray();
        Util.specialCharactersRepresentation[34] = "&#034;".toCharArray();
        Util.specialCharactersRepresentation[39] = "&#039;".toCharArray();
    }
}

