/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xddf.usermodel.chart;

import org.apache.poi.util.Internal;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrVal;

public interface XDDFDataSource<T> {
    public int getPointCount();

    public T getPointAt(int var1);

    public boolean isLiteral();

    public boolean isCellRange();

    public boolean isReference();

    public boolean isNumeric();

    public int getColIndex();

    public String getDataRangeReference();

    public String getFormula();

    @Internal
    default public void fillStringCache(CTStrData cache) {
        cache.setPtArray(null);
        int numOfPoints = this.getPointCount();
        int effectiveNumOfPoints = 0;
        for (int i2 = 0; i2 < numOfPoints; ++i2) {
            T value = this.getPointAt(i2);
            if (value == null) continue;
            CTStrVal ctStrVal = cache.addNewPt();
            ctStrVal.setIdx(i2);
            ctStrVal.setV(value.toString());
            ++effectiveNumOfPoints;
        }
        if (effectiveNumOfPoints == 0) {
            if (cache.isSetPtCount()) {
                cache.unsetPtCount();
            }
        } else if (cache.isSetPtCount()) {
            cache.getPtCount().setVal(numOfPoints);
        } else {
            cache.addNewPtCount().setVal(numOfPoints);
        }
    }
}

