/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.http11.upgrade.UpgradeProcessorBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class UpgradeServletInputStream
extends ServletInputStream {
    private static final Log log = LogFactory.getLog(UpgradeServletInputStream.class);
    private static final StringManager sm = StringManager.getManager(UpgradeServletInputStream.class);
    private final UpgradeProcessorBase processor;
    private final SocketWrapperBase<?> socketWrapper;
    private volatile boolean closed = false;
    private volatile boolean eof = false;
    private volatile Boolean ready = Boolean.TRUE;
    private volatile ReadListener listener = null;

    public UpgradeServletInputStream(UpgradeProcessorBase processor, SocketWrapperBase<?> socketWrapper) {
        this.processor = processor;
        this.socketWrapper = socketWrapper;
    }

    @Override
    public final boolean isFinished() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sis.isFinished.ise"));
        }
        return this.eof;
    }

    @Override
    public final boolean isReady() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sis.isReady.ise"));
        }
        if (this.eof || this.closed) {
            return false;
        }
        if (this.ready != null) {
            return this.ready;
        }
        try {
            this.ready = this.socketWrapper.isReadyForRead();
        }
        catch (IOException e2) {
            this.onError(e2);
        }
        return this.ready;
    }

    @Override
    public final void setReadListener(ReadListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sis.readListener.null"));
        }
        if (this.listener != null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sis.readListener.set"));
        }
        if (this.closed) {
            throw new IllegalStateException(sm.getString("upgrade.sis.read.closed"));
        }
        this.listener = listener;
        if (ContainerThreadMarker.isContainerThread()) {
            this.processor.addDispatch(DispatchType.NON_BLOCKING_READ);
        } else {
            this.socketWrapper.registerReadInterest();
        }
        this.ready = null;
    }

    @Override
    public final int read() throws IOException {
        this.preReadChecks();
        return this.readInternal();
    }

    @Override
    public final int readLine(byte[] b2, int off, int len) throws IOException {
        int c2;
        this.preReadChecks();
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c2 = this.readInternal()) != -1) {
            b2[off++] = (byte)c2;
            if (c2 != 10 && ++count != len) continue;
        }
        return count > 0 ? count : -1;
    }

    @Override
    public final int read(byte[] b2, int off, int len) throws IOException {
        this.preReadChecks();
        try {
            int result = this.socketWrapper.read(this.listener == null, b2, off, len);
            if (result == -1) {
                this.eof = true;
            }
            return result;
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
    }

    @Override
    public void close() throws IOException {
        this.eof = true;
        this.closed = true;
    }

    private void preReadChecks() {
        if (!(this.listener == null || this.ready != null && this.ready.booleanValue())) {
            throw new IllegalStateException(sm.getString("upgrade.sis.read.ise"));
        }
        if (this.closed) {
            throw new IllegalStateException(sm.getString("upgrade.sis.read.closed"));
        }
        this.ready = null;
    }

    private int readInternal() throws IOException {
        int result;
        byte[] b2 = new byte[1];
        try {
            result = this.socketWrapper.read(this.listener == null, b2, 0, 1);
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
        if (result == 0) {
            return -1;
        }
        if (result == -1) {
            this.eof = true;
            return -1;
        }
        return b2[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onDataAvailable() {
        try {
            if (this.listener == null || !this.socketWrapper.isReadyForRead()) {
                return;
            }
        }
        catch (IOException e2) {
            this.onError(e2);
        }
        this.ready = Boolean.TRUE;
        ClassLoader oldCL = this.processor.getUpgradeToken().getContextBind().bind(false, null);
        try {
            if (!this.eof) {
                this.listener.onDataAvailable();
            }
            if (this.eof) {
                this.listener.onAllDataRead();
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.onError(t);
        }
        finally {
            this.processor.getUpgradeToken().getContextBind().unbind(false, oldCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onError(Throwable t) {
        block9: {
            if (this.listener == null) {
                return;
            }
            ClassLoader oldCL = this.processor.getUpgradeToken().getContextBind().bind(false, null);
            try {
                this.listener.onError(t);
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                log.warn((Object)sm.getString("upgrade.sis.onErrorFail"), t2);
            }
            finally {
                this.processor.getUpgradeToken().getContextBind().unbind(false, oldCL);
            }
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)sm.getString("upgrade.sis.errorCloseFail"), (Throwable)ioe);
            }
        }
        this.ready = Boolean.FALSE;
    }

    final boolean isClosed() {
        return this.closed;
    }
}

