/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.config;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionConverter {
    private static final Log log = LogFactory.getLog(OptionConverter.class);
    private static final String DELIM_START = "${";
    private static final char DELIM_STOP = '}';
    private static final int DELIM_START_LEN = 2;
    private static final int DELIM_STOP_LEN = 1;

    private OptionConverter() {
    }

    public static String[] concatanateArrays(String[] l2, String[] r2) {
        int len = l2.length + r2.length;
        String[] a2 = new String[len];
        System.arraycopy(l2, 0, a2, 0, l2.length);
        System.arraycopy(r2, 0, a2, l2.length, r2.length);
        return a2;
    }

    public static String convertSpecialChars(String s2) {
        int len = s2.length();
        StringBuilder sb = new StringBuilder(len);
        int i2 = 0;
        while (i2 < len) {
            int c2;
            if ((c2 = s2.charAt(i2++)) == 92) {
                if ((c2 = s2.charAt(i2++)) == 110) {
                    c2 = 10;
                } else if (c2 == 114) {
                    c2 = 13;
                } else if (c2 == 116) {
                    c2 = 9;
                } else if (c2 == 102) {
                    c2 = 12;
                } else if (c2 == 8) {
                    c2 = 8;
                } else if (c2 == 34) {
                    c2 = 34;
                } else if (c2 == 39) {
                    c2 = 39;
                } else if (c2 == 92) {
                    c2 = 92;
                }
            }
            sb.append((char)c2);
        }
        return sb.toString();
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable e2) {
            log.debug("Was not allowed to read system property \"" + key + "\".");
            return def;
        }
    }

    public static <T> T instantiateByKey(Properties props, String key, T defaultValue) {
        String className = OptionConverter.findAndSubst(key, props);
        if (className == null) {
            if (log.isTraceEnabled()) {
                log.info("Could not find value for key " + key);
            }
            return defaultValue;
        }
        return OptionConverter.instantiateByClassName(className.trim(), defaultValue);
    }

    public static boolean toBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String trimmedVal = value.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return defaultValue;
    }

    public static int toInt(String value, int defaultValue) {
        if (value != null) {
            String s2 = value.trim();
            try {
                return Integer.parseInt(s2);
            }
            catch (NumberFormatException e2) {
                log.error("[" + s2 + "] is not in proper int form.");
                e2.printStackTrace();
            }
        }
        return defaultValue;
    }

    public static long toFileSize(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String s2 = value.trim().toUpperCase();
        long multiplier = 1L;
        int index = s2.indexOf("KB");
        if (index != -1) {
            multiplier = 1024L;
            s2 = s2.substring(0, index);
        } else {
            index = s2.indexOf("MB");
            if (index != -1) {
                multiplier = 0x100000L;
                s2 = s2.substring(0, index);
            } else {
                index = s2.indexOf("GB");
                if (index != -1) {
                    multiplier = 0x40000000L;
                    s2 = s2.substring(0, index);
                }
            }
        }
        if (s2 != null) {
            try {
                return Long.parseLong(s2) * multiplier;
            }
            catch (NumberFormatException e2) {
                log.error("[" + s2 + "] is not in proper int form");
                log.error("[" + value + "] not in expected format", e2);
            }
        }
        return defaultValue;
    }

    public static String findAndSubst(String key, Properties props) {
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value, props);
        }
        catch (IllegalArgumentException e2) {
            log.error("Bad option value [" + value + "]", e2);
            return value;
        }
    }

    public static <T> T instantiateByClassName(String className, T defaultValue) {
        if (className != null) {
            try {
                Class<?> classObj = Class.forName(className);
                Object o2 = classObj.newInstance();
                try {
                    Object t = o2;
                    return (T)t;
                }
                catch (ClassCastException e2) {
                    log.error("A \"" + className + "\" object is not assignable to the generic variable.");
                    return defaultValue;
                }
            }
            catch (Exception e3) {
                log.error("Could not instantiate class [" + className + "]", e3);
            }
        }
        return defaultValue;
    }

    public static String substVars(String val, Properties props) throws IllegalArgumentException {
        StringBuilder sbuf = new StringBuilder();
        int i2 = 0;
        while (true) {
            int j2;
            if ((j2 = val.indexOf(DELIM_START, i2)) == -1) {
                if (i2 == 0) {
                    return val;
                }
                sbuf.append(val.substring(i2, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i2, j2));
            int k2 = val.indexOf(125, j2);
            if (k2 == -1) {
                throw new IllegalArgumentException('\"' + val + "\" has no closing brace. Opening brace at position " + j2 + '.');
            }
            String key = val.substring(j2 += 2, k2);
            String replacement = OptionConverter.getSystemProperty(key, null);
            if (replacement == null && props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement != null) {
                sbuf.append(replacement);
            }
            i2 = k2 + 1;
        }
    }
}

